/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.session;

import org.redisson.api.RedissonClient;
import org.redisson.spring.session.RedissonSessionRepository;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.session.ReactiveSessionRepository;
import reactor.core.publisher.Mono;

public class ReactiveRedissonSessionRepository
implements ReactiveSessionRepository<RedissonSessionRepository.RedissonSession> {
    private final RedissonSessionRepository repository;

    public ReactiveRedissonSessionRepository(RedissonClient redissonClient, ApplicationEventPublisher eventPublisher, String keyPrefix) {
        this.repository = new RedissonSessionRepository(redissonClient, eventPublisher, keyPrefix);
    }

    public void setDefaultMaxInactiveInterval(int defaultMaxInactiveInterval) {
        this.repository.setDefaultMaxInactiveInterval(defaultMaxInactiveInterval);
    }

    public Mono<RedissonSessionRepository.RedissonSession> createSession() {
        return Mono.fromCallable(() -> this.repository.createSession());
    }

    public Mono<Void> save(RedissonSessionRepository.RedissonSession session) {
        return Mono.empty();
    }

    public Mono<RedissonSessionRepository.RedissonSession> findById(String id) {
        return Mono.fromCallable(() -> this.repository.findById(id));
    }

    public Mono<Void> deleteById(String id) {
        return Mono.fromRunnable(() -> this.repository.deleteById(id));
    }
}

