/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.cluster.ClusterConnectionManager;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.SubscriptionMode;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.balancer.LoadBalancerManager;
import org.redisson.connection.pool.MasterConnectionPool;
import org.redisson.connection.pool.MasterPubSubConnectionPool;
import org.redisson.misc.CountableListener;
import org.redisson.misc.RedisURI;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.TransferListener;
import org.redisson.pubsub.PubSubConnectionEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveEntry {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    LoadBalancerManager slaveBalancer;
    ClientConnectionsEntry masterEntry;
    int references;
    final MasterSlaveServersConfig config;
    final ConnectionManager connectionManager;
    final MasterConnectionPool writeConnectionPool;
    final MasterPubSubConnectionPool pubSubConnectionPool;
    final AtomicBoolean active = new AtomicBoolean(true);
    String sslHostname;

    public MasterSlaveEntry(ConnectionManager connectionManager, MasterSlaveServersConfig config) {
        this.connectionManager = connectionManager;
        this.config = config;
        this.slaveBalancer = new LoadBalancerManager(config, connectionManager, this);
        this.writeConnectionPool = new MasterConnectionPool(config, connectionManager, this);
        this.pubSubConnectionPool = new MasterPubSubConnectionPool(config, connectionManager, this);
        if (connectionManager instanceof ClusterConnectionManager) {
            this.sslHostname = ((ClusterConnectionManager)connectionManager).getConfigEndpointHostName();
        }
    }

    public MasterSlaveServersConfig getConfig() {
        return this.config;
    }

    public List<RFuture<Void>> initSlaveBalancer(Collection<RedisURI> disconnectedNodes) {
        boolean freezeMasterAsSlave = !this.config.getSlaveAddresses().isEmpty() && !this.config.checkSkipSlavesInit() && disconnectedNodes.size() < this.config.getSlaveAddresses().size();
        LinkedList<RFuture<Void>> result = new LinkedList<RFuture<Void>>();
        RFuture<Void> f = this.addSlave(new RedisURI(this.config.getMasterAddress()), freezeMasterAsSlave, NodeType.MASTER);
        result.add(f);
        for (String address : this.config.getSlaveAddresses()) {
            RedisURI uri = new RedisURI(address);
            f = this.addSlave(uri, disconnectedNodes.contains(uri), NodeType.SLAVE);
            result.add(f);
        }
        return result;
    }

    public RFuture<RedisClient> setupMasterEntry(InetSocketAddress address, RedisURI uri) {
        RedisClient client = this.connectionManager.createClient(NodeType.MASTER, address, uri, this.sslHostname);
        return this.setupMasterEntry(client);
    }

    public RFuture<RedisClient> setupMasterEntry(RedisURI address) {
        RedisClient client = this.connectionManager.createClient(NodeType.MASTER, address, this.sslHostname);
        return this.setupMasterEntry(client);
    }

    private RFuture<RedisClient> setupMasterEntry(RedisClient client) {
        RedissonPromise<RedisClient> result = new RedissonPromise<RedisClient>();
        RFuture<InetSocketAddress> addrFuture = client.resolveAddr();
        addrFuture.onComplete((res, e) -> {
            if (e != null) {
                client.shutdownAsync();
                result.tryFailure((Throwable)e);
                return;
            }
            this.masterEntry = new ClientConnectionsEntry(client, this.config.getMasterConnectionMinimumIdleSize(), this.config.getMasterConnectionPoolSize(), this.config.getSubscriptionConnectionMinimumIdleSize(), this.config.getSubscriptionConnectionPoolSize(), this.connectionManager, NodeType.MASTER);
            int counter = 1;
            if (this.config.getSubscriptionMode() == SubscriptionMode.MASTER) {
                ++counter;
            }
            CountableListener<RedisClient> listener = new CountableListener<RedisClient>(result, client, counter);
            RFuture writeFuture = this.writeConnectionPool.add(this.masterEntry);
            writeFuture.onComplete(listener);
            if (this.config.getSubscriptionMode() == SubscriptionMode.MASTER) {
                RFuture pubSubFuture = this.pubSubConnectionPool.add(this.masterEntry);
                pubSubFuture.onComplete(listener);
            }
        });
        return result;
    }

    public boolean slaveDown(ClientConnectionsEntry entry, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry e = this.slaveBalancer.freeze(entry, freezeReason);
        if (e == null) {
            return false;
        }
        return this.slaveDown(entry);
    }

    public boolean slaveDown(InetSocketAddress address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.slaveBalancer.freeze(address, freezeReason);
        if (entry == null) {
            return false;
        }
        return this.slaveDown(entry);
    }

    public boolean slaveDown(RedisURI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.slaveBalancer.freeze(address, freezeReason);
        if (entry == null) {
            return false;
        }
        return this.slaveDown(entry);
    }

    private boolean slaveDown(ClientConnectionsEntry entry) {
        Object connection;
        if (entry.isMasterForRead()) {
            return false;
        }
        if (!this.config.checkSkipSlavesInit() && this.slaveBalancer.getAvailableClients() == 0 && this.slaveBalancer.unfreeze(this.masterEntry.getClient().getAddr(), ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} used as slave", (Object)this.masterEntry.getClient().getAddr());
        }
        entry.reset();
        for (RedisConnection connection2 : entry.getAllConnections()) {
            connection2.closeAsync();
            this.reattachBlockingQueue(connection2);
        }
        while ((connection = entry.pollConnection()) != null) {
        }
        entry.getAllConnections().clear();
        connection = entry.getAllSubscribeConnections().iterator();
        while (connection.hasNext()) {
            RedisConnection connection2;
            connection2 = (RedisPubSubConnection)connection.next();
            connection2.closeAsync();
            this.connectionManager.getSubscribeService().reattachPubSub((RedisPubSubConnection)connection2);
        }
        while ((connection = entry.pollSubscribeConnection()) != null) {
        }
        entry.getAllSubscribeConnections().clear();
        return true;
    }

    private void reattachBlockingQueue(RedisConnection connection) {
        CommandData<?, ?> commandData = connection.getCurrentCommand();
        if (commandData == null || !commandData.isBlockingCommand() || commandData.getPromise().isDone()) {
            return;
        }
        RFuture<RedisConnection> newConnectionFuture = this.connectionWriteOp(commandData.getCommand());
        newConnectionFuture.onComplete((newConnection, e) -> {
            if (e != null) {
                this.log.error("Can't resubscribe blocking queue " + commandData, e);
                return;
            }
            if (commandData.getPromise().isDone()) {
                this.releaseWrite((RedisConnection)newConnection);
                return;
            }
            ChannelFuture channelFuture = newConnection.send(commandData);
            channelFuture.addListener(future -> {
                if (!future.isSuccess()) {
                    commandData.getPromise().tryFailure(new RedisException("Can't resubscribe blocking queue " + commandData + " to " + newConnection));
                }
            });
            commandData.getPromise().onComplete((r, ex) -> this.releaseWrite((RedisConnection)newConnection));
        });
    }

    public boolean hasSlave(RedisClient redisClient) {
        return this.slaveBalancer.contains(redisClient);
    }

    public boolean hasSlave(InetSocketAddress addr) {
        return this.slaveBalancer.contains(addr);
    }

    public boolean hasSlave(RedisURI addr) {
        return this.slaveBalancer.contains(addr);
    }

    public int getAvailableClients() {
        return this.slaveBalancer.getAvailableClients();
    }

    public RFuture<Void> addSlave(RedisURI address) {
        return this.addSlave(address, false, NodeType.SLAVE);
    }

    public RFuture<Void> addSlave(InetSocketAddress address, RedisURI uri) {
        return this.addSlave(address, uri, false, NodeType.SLAVE);
    }

    private RFuture<Void> addSlave(RedisClient client, boolean freezed, NodeType nodeType) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<InetSocketAddress> addrFuture = client.resolveAddr();
        addrFuture.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            ClientConnectionsEntry entry = new ClientConnectionsEntry(client, this.config.getSlaveConnectionMinimumIdleSize(), this.config.getSlaveConnectionPoolSize(), this.config.getSubscriptionConnectionMinimumIdleSize(), this.config.getSubscriptionConnectionPoolSize(), this.connectionManager, nodeType);
            if (freezed) {
                ClientConnectionsEntry clientConnectionsEntry = entry;
                synchronized (clientConnectionsEntry) {
                    entry.setFreezed(freezed);
                    entry.setFreezeReason(ClientConnectionsEntry.FreezeReason.SYSTEM);
                }
            }
            RFuture<Void> addFuture = this.slaveBalancer.add(entry);
            addFuture.onComplete((r, ex) -> {
                if (ex != null) {
                    client.shutdownAsync();
                }
            });
            addFuture.onComplete(new TransferListener(result));
        });
        return result;
    }

    private RFuture<Void> addSlave(InetSocketAddress address, RedisURI uri, boolean freezed, NodeType nodeType) {
        RedisClient client = this.connectionManager.createClient(NodeType.SLAVE, address, uri, this.sslHostname);
        return this.addSlave(client, freezed, nodeType);
    }

    private RFuture<Void> addSlave(RedisURI address, boolean freezed, NodeType nodeType) {
        RedisClient client = this.connectionManager.createClient(nodeType, address, this.sslHostname);
        return this.addSlave(client, freezed, nodeType);
    }

    public Collection<ClientConnectionsEntry> getAllEntries() {
        return this.slaveBalancer.getEntries();
    }

    public ClientConnectionsEntry getEntry(RedisClient redisClient) {
        return this.slaveBalancer.getEntry(redisClient);
    }

    public RedisClient getClient() {
        return this.masterEntry.getClient();
    }

    public boolean slaveUp(ClientConnectionsEntry entry, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (!this.slaveBalancer.unfreeze(entry, freezeReason)) {
            return false;
        }
        InetSocketAddress addr = this.masterEntry.getClient().getAddr();
        if (!this.config.checkSkipSlavesInit() && !addr.equals(entry.getClient().getAddr()) && this.slaveDown(addr, ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} excluded from slaves", (Object)addr);
        }
        return true;
    }

    public boolean isSlaveUnfreezed(RedisURI address) {
        return this.slaveBalancer.isUnfreezed(address);
    }

    public boolean slaveUp(RedisURI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (!this.slaveBalancer.unfreeze(address, freezeReason)) {
            return false;
        }
        InetSocketAddress addr = this.masterEntry.getClient().getAddr();
        if (!this.config.checkSkipSlavesInit() && !RedisURI.compare(addr, address) && this.slaveDown(addr, ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} excluded from slaves", (Object)addr);
        }
        return true;
    }

    public boolean slaveUp(InetSocketAddress address, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (!this.slaveBalancer.unfreeze(address, freezeReason)) {
            return false;
        }
        InetSocketAddress addr = this.masterEntry.getClient().getAddr();
        if (!this.config.checkSkipSlavesInit() && !addr.equals(address) && this.slaveDown(addr, ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} excluded from slaves", (Object)addr);
        }
        return true;
    }

    public RFuture<RedisClient> changeMaster(RedisURI address) {
        ClientConnectionsEntry oldMaster = this.masterEntry;
        RFuture<RedisClient> future = this.setupMasterEntry(address);
        this.changeMaster(address, oldMaster, future);
        return future;
    }

    public void changeMaster(InetSocketAddress address, RedisURI uri) {
        ClientConnectionsEntry oldMaster = this.masterEntry;
        RFuture<RedisClient> future = this.setupMasterEntry(address, uri);
        this.changeMaster(uri, oldMaster, future);
    }

    private void changeMaster(RedisURI address, ClientConnectionsEntry oldMaster, RFuture<RedisClient> future) {
        future.onComplete((newMasterClient, e) -> {
            if (e != null) {
                if (oldMaster != this.masterEntry) {
                    this.writeConnectionPool.remove(this.masterEntry);
                    this.pubSubConnectionPool.remove(this.masterEntry);
                    this.masterEntry.getClient().shutdownAsync();
                    this.masterEntry = oldMaster;
                }
                this.log.error("Unable to change master from: " + oldMaster.getClient().getAddr() + " to: " + address, e);
                return;
            }
            this.writeConnectionPool.remove(oldMaster);
            this.pubSubConnectionPool.remove(oldMaster);
            oldMaster.freezeMaster(ClientConnectionsEntry.FreezeReason.MANAGER);
            this.slaveDown(oldMaster);
            this.slaveBalancer.changeType(oldMaster.getClient().getAddr(), NodeType.SLAVE);
            this.slaveBalancer.changeType(newMasterClient.getAddr(), NodeType.MASTER);
            this.slaveDown(oldMaster.getClient().getAddr(), ClientConnectionsEntry.FreezeReason.MANAGER);
            if (!this.config.checkSkipSlavesInit() && this.slaveBalancer.getAvailableClients() > 1) {
                this.slaveDown(newMasterClient.getAddr(), ClientConnectionsEntry.FreezeReason.SYSTEM);
            }
            oldMaster.getClient().shutdownAsync();
            this.log.info("master {} has changed to {}", (Object)oldMaster.getClient().getAddr(), (Object)this.masterEntry.getClient().getAddr());
        });
    }

    public RFuture<Void> shutdownAsync() {
        if (!this.active.compareAndSet(true, false)) {
            return RedissonPromise.newSucceededFuture(null);
        }
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        CountableListener<Object> listener = new CountableListener<Object>(result, null, 2);
        this.masterEntry.getClient().shutdownAsync().onComplete(listener);
        this.slaveBalancer.shutdownAsync().onComplete(listener);
        return result;
    }

    public RFuture<RedisConnection> connectionWriteOp(RedisCommand<?> command) {
        return this.writeConnectionPool.get(command);
    }

    public RFuture<RedisConnection> redirectedConnectionWriteOp(RedisCommand<?> command, RedisURI addr) {
        return this.slaveBalancer.getConnection(command, addr);
    }

    public RFuture<RedisConnection> connectionReadOp(RedisCommand<?> command) {
        if (this.config.getReadMode() == ReadMode.MASTER) {
            return this.connectionWriteOp(command);
        }
        return this.slaveBalancer.nextConnection(command);
    }

    public RFuture<RedisConnection> connectionReadOp(RedisCommand<?> command, RedisURI addr) {
        return this.slaveBalancer.getConnection(command, addr);
    }

    public RFuture<RedisConnection> connectionReadOp(RedisCommand<?> command, RedisClient client) {
        if (this.config.getReadMode() == ReadMode.MASTER) {
            return this.connectionWriteOp(command);
        }
        return this.slaveBalancer.getConnection(command, client);
    }

    public RFuture<RedisPubSubConnection> nextPubSubConnection() {
        if (this.config.getSubscriptionMode() == SubscriptionMode.MASTER) {
            return this.pubSubConnectionPool.get();
        }
        return this.slaveBalancer.nextPubSubConnection();
    }

    public void returnPubSubConnection(PubSubConnectionEntry entry) {
        if (this.config.getSubscriptionMode() == SubscriptionMode.MASTER) {
            this.pubSubConnectionPool.returnConnection(this.masterEntry, entry.getConnection());
            return;
        }
        this.slaveBalancer.returnPubSubConnection(entry.getConnection());
    }

    public void releaseWrite(RedisConnection connection) {
        this.writeConnectionPool.returnConnection(this.masterEntry, connection);
    }

    public void releaseRead(RedisConnection connection) {
        if (this.config.getReadMode() == ReadMode.MASTER) {
            this.releaseWrite(connection);
            return;
        }
        this.slaveBalancer.returnConnection(connection);
    }

    public void incReference() {
        ++this.references;
    }

    public int decReference() {
        return --this.references;
    }

    public int getReferences() {
        return this.references;
    }

    public String toString() {
        return "MasterSlaveEntry [masterEntry=" + this.masterEntry + "]";
    }
}

