/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.resource.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.NutResource;
import org.nutz.resource.impl.ResourceLocation;

public class JarResourceLocation
extends ResourceLocation {
    private static final Log log = Logs.get();
    protected List<String> names = new ArrayList<String>();
    protected URI uri;

    @Override
    public String id() {
        return this.uri.toString();
    }

    @Override
    public void scan(String base, Pattern regex, List<NutResource> list) {
        for (final String ensName : this.names) {
            if (!ensName.startsWith(base)) continue;
            String name = ensName;
            if (name.contains("/")) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            if (null != regex && !regex.matcher(name).find()) continue;
            NutResource nutResource = new NutResource(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return new URL(JarResourceLocation.this.uriJarPrefix(JarResourceLocation.this.uri, "!/" + ensName)).openStream();
                }

                @Override
                public int hashCode() {
                    return (JarResourceLocation.this.id() + ":" + ensName).hashCode();
                }

                @Override
                public String toString() {
                    return JarResourceLocation.this.uriJarPrefix(JarResourceLocation.this.uri, "!/" + ensName);
                }
            };
            if (ensName.equals(base)) {
                nutResource.setName(ensName);
            } else {
                nutResource.setName(ensName.substring(base.length()));
            }
            nutResource.setSource(this.id() + ":" + ensName);
            nutResource.setPriority(75);
            list.add(nutResource);
        }
    }

    public String toString() {
        return this.id();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarResourceLocation(URL url) throws IOException {
        JarURLConnection jarConn = null;
        ZipFile jf = null;
        try {
            this.uri = url.toURI();
            jarConn = (JarURLConnection)new URL(this.uriJarPrefix(url.toURI(), "!/")).openConnection();
            jf = jarConn.getJarFile();
            Enumeration<JarEntry> ens = ((JarFile)jf).entries();
            while (ens.hasMoreElements()) {
                JarEntry en = ens.nextElement();
                this.names.add(en.getName());
            }
        }
        catch (Throwable e) {
            if (log.isTraceEnabled()) {
                log.trace("URL=" + url, e);
            }
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (Throwable ens) {}
            }
        }
    }

    public JarResourceLocation(String jarPath) throws IOException {
        this(new File(jarPath).toURI().toURL());
    }

    private String uriJarPrefix(URI uri, String suffix) {
        String uriString = uri.toString();
        if (uriString.startsWith("jar:")) {
            return uriString + suffix;
        }
        return "jar:" + uriString + suffix;
    }
}

