/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.util.ArrayList;
import java.util.List;
import org.nutz.lang.meta.Pair;

public class HtmlToken {
    private String name;
    private String value;
    private List<Pair<String>> attributes = new ArrayList<Pair<String>>();

    HtmlToken() {
    }

    public String getTagName() {
        return this.name.toUpperCase();
    }

    public String getName() {
        return this.name;
    }

    public HtmlToken setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public HtmlToken setValue(String value) {
        this.value = value;
        return this;
    }

    public boolean isElement() {
        return null != this.name;
    }

    public boolean isText() {
        return null == this.name && this.value != null;
    }

    public HtmlToken attr(String name, String value) {
        Pair<String> attr = this.getAttr(name);
        if (null == attr) {
            attr = new Pair<String>(name, value);
            this.attributes.add(attr);
        } else {
            attr.setValue(value);
        }
        return this;
    }

    public HtmlToken attr(String name, int value) {
        return this.attr(name, String.valueOf(value));
    }

    public Pair<String> getAttr(String name) {
        for (Pair<String> attr : this.attributes) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public String getAttrVal(String name) {
        Pair<String> p = this.getAttr(name);
        return p == null ? null : p.getValueString();
    }

    public List<Pair<String>> getAttributes() {
        return this.attributes;
    }
}

