/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.FloatRange;

public class FloatSet {
    private char l;
    private char r;
    private FloatRange ir;

    public static FloatSet make(String s) {
        if (s.length() < 3) {
            throw Lang.makeThrow("Invalid FloatSet : '%s'", s);
        }
        s = Strings.trim(s);
        char l = s.charAt(0);
        char r = s.charAt(s.length() - 1);
        FloatRange ir = FloatRange.make(s.substring(1, s.length() - 1));
        return new FloatSet(l, r, ir);
    }

    private FloatSet(char l, char r, FloatRange ir) {
        this.l = l;
        this.r = r;
        this.ir = ir;
    }

    public boolean match(float n) {
        if (this.l == '[' && this.r == ']') {
            return this.ir.inon(n);
        }
        if (this.l == '(' && this.r == ')') {
            return this.ir.in(n);
        }
        if (this.l == '[') {
            return this.ir.linon(n);
        }
        return this.ir.rinon(n);
    }

    public String toString() {
        return this.l + this.ir.toString() + this.r;
    }
}

