/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.inject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.nutz.castor.Castors;
import org.nutz.conf.NutConf;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.inject.Injecting;
import org.nutz.lang.reflect.FastClassFactory;
import org.nutz.lang.reflect.FastMethod;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class InjectBySetter
implements Injecting {
    private static final Log log = Logs.get();
    protected FastMethod fm;
    private Method setter;
    private Class<?> valueType;
    private Type type;
    private boolean isMapCollection;

    public InjectBySetter(Method setter) {
        this.setter = setter;
        this.valueType = setter.getParameterTypes()[0];
        this.type = setter.getGenericParameterTypes()[0];
        this.isMapCollection = Map.class.isAssignableFrom(this.valueType) || Collection.class.isAssignableFrom(this.valueType);
    }

    @Override
    public void inject(Object obj, Object value) {
        Object v = null;
        try {
            v = this.isMapCollection && value != null && value instanceof String ? Json.fromJson(this.type, (CharSequence)value.toString()) : (Object)Castors.me().castTo(value, this.valueType);
            if (NutConf.USE_FASTCLASS) {
                if (this.fm == null) {
                    this.fm = FastClassFactory.get(this.setter);
                }
                this.fm.invoke(obj, v);
            } else {
                this.setter.invoke(obj, v);
            }
        }
        catch (Exception _e) {
            Throwable e = _e;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (log.isInfoEnabled()) {
                log.info("Fail to value by setter", e);
            }
            throw Lang.wrapThrow(e, "Fail to set '%s'[ %s ] by setter %s.'%s()' because [%s]: %s", value, v == null ? value : v, this.setter.getDeclaringClass().getName(), this.setter.getName(), Lang.unwrapThrow(e), Lang.unwrapThrow(e).getMessage());
        }
    }
}

