/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nutz.lang.Times;

public class Stopwatch {
    private boolean nano;
    private long from;
    private long to;
    private List<StopTag> tags;
    private StopTag lastTag;

    public static Stopwatch begin() {
        Stopwatch sw = new Stopwatch();
        sw.start();
        return sw;
    }

    public static Stopwatch beginNano() {
        Stopwatch sw = new Stopwatch();
        sw.nano = true;
        sw.start();
        return sw;
    }

    public static Stopwatch create() {
        return new Stopwatch();
    }

    public static Stopwatch createNano() {
        Stopwatch sw = new Stopwatch();
        sw.nano = true;
        return sw;
    }

    public static Stopwatch run(Runnable atom) {
        Stopwatch sw = Stopwatch.begin();
        atom.run();
        sw.stop();
        return sw;
    }

    public static Stopwatch runNano(Runnable atom) {
        Stopwatch sw = Stopwatch.beginNano();
        atom.run();
        sw.stop();
        return sw;
    }

    public long start() {
        this.to = this.from = this.currentTime();
        return this.from;
    }

    private long currentTime() {
        return this.nano ? System.nanoTime() : System.currentTimeMillis();
    }

    public long stop() {
        this.to = this.currentTime();
        return this.to;
    }

    public long getDuration() {
        return this.to - this.from;
    }

    public long du() {
        return this.to - this.from;
    }

    public long getStartTime() {
        return this.from;
    }

    public long getEndTime() {
        return this.to;
    }

    public String toString() {
        String prefix = String.format("Total: %d%s : [%s]=>[%s]", this.getDuration(), this.nano ? "ns" : "ms", Times.sDTms(new Date(this.from)), Times.sDTms(new Date(this.to)));
        if (this.tags == null) {
            return prefix;
        }
        StringBuilder sb = new StringBuilder(prefix).append("\r\n");
        for (int i = 0; i < this.tags.size(); ++i) {
            StopTag tag = this.tags.get(i);
            sb.append(String.format("  -> %5s: %dms", tag.name == null ? "TAG" + i : tag.name, tag.du()));
            if (i >= this.tags.size() - 1) continue;
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public StopTag tag(String name) {
        if (this.tags == null) {
            this.tags = new ArrayList<StopTag>();
        }
        this.lastTag = new StopTag(name, System.currentTimeMillis(), this.lastTag);
        this.tags.add(this.lastTag);
        return this.lastTag;
    }

    public StopTag tagf(String fmt, Object ... args) {
        return this.tag(String.format(fmt, args));
    }

    public class StopTag {
        public String name;
        public long tm;
        public StopTag pre;

        public StopTag() {
        }

        public StopTag(String name, long tm, StopTag pre) {
            this.name = name;
            this.tm = tm;
            this.pre = pre;
        }

        public long du() {
            if (this.pre == null) {
                return this.tm - Stopwatch.this.from;
            }
            return this.tm - this.pre.tm;
        }
    }
}

