/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.impl;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.json.JsonRender;
import org.nutz.json.entity.JsonEntity;
import org.nutz.json.entity.JsonEntityField;
import org.nutz.lang.FailToGetValueException;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;

public class JsonRenderImpl
implements JsonRender {
    private static String NL = "\n";
    private JsonFormat format;
    private Writer writer;
    private Set<Object> memo = new HashSet<Object>();
    private boolean compact;
    private static final Pattern p = Pattern.compile("^[a-z_A-Z$]+[a-zA-Z_0-9$]*$");

    public JsonFormat getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(JsonFormat format) {
        this.format = format;
        this.compact = format.isCompact();
    }

    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void render(Object obj) throws IOException {
        if (null == obj) {
            this.appendNull();
        } else if (obj instanceof JsonRender) {
            ((JsonRender)obj).render(null);
        } else if (obj instanceof Class) {
            this.string2Json(((Class)obj).getName());
        } else if (obj instanceof Mirror) {
            this.string2Json(((Mirror)obj).getType().getName());
        } else {
            Mirror<Class<?>> mr = Mirror.me(obj.getClass());
            if (mr.isEnum()) {
                this.string2Json(((Enum)obj).name());
            } else if (mr.isNumber()) {
                String tmp = obj.toString();
                if (tmp.equals("NaN")) {
                    this.writer.write("null");
                } else {
                    this.writer.write(tmp);
                }
            } else if (mr.isBoolean()) {
                this.writer.append(obj.toString());
            } else if (mr.isStringLike() || mr.isChar()) {
                this.string2Json(obj.toString());
            } else if (mr.isDateTimeLike()) {
                String _val;
                boolean flag = true;
                if (obj instanceof Date && (_val = this.doDateFormat((Date)obj, null)) != null) {
                    this.string2Json(_val);
                    flag = false;
                }
                if (flag) {
                    this.string2Json(this.format.getCastors().castToString(obj));
                }
            } else {
                if (this.memo.contains(obj)) {
                    this.writer.write("null");
                    return;
                }
                this.memo.add(obj);
                if (obj instanceof Map) {
                    this.map2Json((Map)obj);
                } else if (obj instanceof Iterable) {
                    this.coll2Json((Iterable)obj);
                } else if (obj.getClass().isArray()) {
                    this.array2Json(obj);
                } else {
                    this.pojo2Json(obj);
                }
                this.memo.remove(obj);
            }
        }
    }

    public JsonRenderImpl() {
    }

    public JsonRenderImpl(Writer writer, JsonFormat format) {
        this.writer = writer;
        this.setFormat(format);
    }

    private void appendName(String name) throws IOException {
        if (this.format.isQuoteName() || !p.matcher(name).find()) {
            this.string2Json(name);
        } else {
            this.writer.append(name);
        }
    }

    private void appendPairBegin() throws IOException {
        if (!this.compact) {
            this.writer.append(NL);
            this.doIntent();
        }
    }

    private void appendPairSep() throws IOException {
        this.writer.append(!this.compact ? ": " : ":");
    }

    protected void appendPair(boolean needPairEnd, String name, Object value) throws IOException {
        this.appendPairBegin();
        this.appendName(name);
        this.appendPairSep();
        this.render(value);
        if (needPairEnd) {
            this.appendPairEnd();
        }
    }

    private boolean isIgnore(String name, Object value) {
        if (null == value && this.format.isIgnoreNull()) {
            return true;
        }
        return this.format.ignore(name);
    }

    private void appendPairEnd() throws IOException {
        this.writer.append(',');
    }

    private void appendBraceBegin() throws IOException {
        this.writer.append('{');
    }

    private void appendBraceEnd() throws IOException {
        if (!this.compact) {
            this.writer.append(NL);
            this.doIntent();
        }
        this.writer.append('}');
    }

    private void map2Json(Map map) throws IOException {
        if (null == map) {
            return;
        }
        this.appendBraceBegin();
        this.increaseFormatIndent();
        ArrayList<Pair> list = new ArrayList<Pair>(map.size());
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            Object value;
            String name = null == entry.getKey() ? "null" : entry.getKey().toString();
            if (this.isIgnore(name, value = entry.getValue())) continue;
            list.add(new Pair(name, value));
        }
        this.writeItem(list);
    }

    private void pojo2Json(Object obj) throws IOException {
        if (null == obj) {
            return;
        }
        Class<?> type = obj.getClass();
        JsonEntity jen = Json.getEntity(Mirror.me(type));
        Method toJsonMethod = jen.getToJsonMethod();
        if (toJsonMethod != null) {
            try {
                if (toJsonMethod.getParameterTypes().length == 0) {
                    this.writer.append(String.valueOf(toJsonMethod.invoke(obj, new Object[0])));
                } else {
                    this.writer.append(String.valueOf(toJsonMethod.invoke(obj, this.format)));
                }
                return;
            }
            catch (Exception e) {
                throw Lang.wrapThrow(e);
            }
        }
        List<JsonEntityField> fields = jen.getFields();
        this.appendBraceBegin();
        this.increaseFormatIndent();
        ArrayList<Pair> list = new ArrayList<Pair>(fields.size());
        for (JsonEntityField jef : fields) {
            if (jef.isIgnore()) continue;
            String name = jef.getName();
            try {
                Object value = jef.getValue(obj);
                if (this.isIgnore(name, value)) continue;
                Mirror<?> mirror = jef.getMirror();
                if (null != value && mirror.isPojo() && this.memo.contains(value)) {
                    value = null;
                }
                if (null == value) {
                    if (mirror != null) {
                        if (mirror.isStringLike()) {
                            if (this.format.isNullStringAsEmpty()) {
                                value = "";
                            }
                        } else if (mirror.isNumber()) {
                            if (this.format.isNullNumberAsZero()) {
                                value = 0;
                            }
                        } else if (mirror.isCollection()) {
                            if (this.format.isNullListAsEmpty()) {
                                value = Collections.EMPTY_LIST;
                            }
                        } else if (jef.getGenericType() == Boolean.class && this.format.isNullBooleanAsFalse()) {
                            value = false;
                        }
                    }
                } else if (jef.isForceString()) {
                    if (value.getClass().isArray()) {
                        String[] ss = new String[Array.getLength(value)];
                        for (int i = 0; i < ss.length; ++i) {
                            ss[i] = Array.get(value, i).toString();
                        }
                        value = ss;
                    } else if (value instanceof Collection) {
                        Collection col = (Collection)Mirror.me(value).born(new Object[0]);
                        for (Object ele : (Collection)value) {
                            col.add(ele.toString());
                        }
                        value = col;
                    } else {
                        value = this.value2string(jef, value);
                    }
                } else if (jef.hasDataFormat() && value instanceof Date) {
                    value = jef.getDataFormat().format((Date)value);
                } else if (jef.hasDataFormat() && mirror != null && mirror.isNumber()) {
                    value = jef.getDataFormat().format(value);
                }
                list.add(new Pair(name, value));
            }
            catch (FailToGetValueException failToGetValueException) {}
        }
        this.writeItem(list);
    }

    private void writeItem(List<Pair> list) throws IOException {
        Iterator<Pair> it = list.iterator();
        while (it.hasNext()) {
            Pair p = it.next();
            this.appendPair(it.hasNext(), p.name, p.value);
        }
        this.decreaseFormatIndent();
        this.appendBraceEnd();
    }

    private void decreaseFormatIndent() {
        if (!this.compact) {
            this.format.decreaseIndent();
        }
    }

    private void increaseFormatIndent() {
        if (!this.compact) {
            this.format.increaseIndent();
        }
    }

    private void string2Json(String s) throws IOException {
        if (null == s) {
            this.appendNull();
        } else {
            char[] cs = s.toCharArray();
            this.writer.append(this.format.getSeparator());
            block9: for (char c : cs) {
                switch (c) {
                    case '\"': {
                        this.writer.append("\\\"");
                        continue block9;
                    }
                    case '\n': {
                        this.writer.append("\\n");
                        continue block9;
                    }
                    case '\t': 
                    case '\u000b': {
                        this.writer.append("\\t");
                        continue block9;
                    }
                    case '\r': {
                        this.writer.append("\\r");
                        continue block9;
                    }
                    case '\f': {
                        this.writer.append("\\f");
                        continue block9;
                    }
                    case '\b': {
                        this.writer.append("\\b");
                        continue block9;
                    }
                    case '\\': {
                        this.writer.append("\\\\");
                        continue block9;
                    }
                    default: {
                        if (c >= '\u0100' && this.format.isAutoUnicode()) {
                            this.writer.append("\\u");
                            String u = Strings.fillHex(c, 4);
                            if (this.format.isUnicodeLower()) {
                                this.writer.write(u.toLowerCase());
                                continue block9;
                            }
                            this.writer.write(u.toUpperCase());
                            continue block9;
                        }
                        if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                            this.writer.write("\\u");
                            String hhhh = Integer.toHexString(c);
                            this.writer.write("0000", 0, 4 - hhhh.length());
                            this.writer.write(hhhh);
                            continue block9;
                        }
                        this.writer.append(c);
                    }
                }
            }
            this.writer.append(this.format.getSeparator());
        }
    }

    private void array2Json(Object obj) throws IOException {
        this.writer.append('[');
        int len = Array.getLength(obj) - 1;
        if (len > -1) {
            int i;
            for (i = 0; i < len; ++i) {
                this.render(Array.get(obj, i));
                this.appendPairEnd();
                this.writer.append(' ');
            }
            this.render(Array.get(obj, i));
        }
        this.writer.append(']');
    }

    private void coll2Json(Iterable iterable) throws IOException {
        this.writer.append('[');
        Iterator it = iterable.iterator();
        while (it.hasNext()) {
            this.render(it.next());
            if (!it.hasNext()) break;
            this.appendPairEnd();
            this.writer.append(' ');
        }
        this.writer.append(']');
    }

    protected String value2string(JsonEntityField jef, Object value) {
        Format df = jef.getDataFormat();
        if (df == null) {
            Mirror<Object> mirror = Mirror.me(value);
            if (value instanceof Date) {
                df = this.format.getDateFormat();
            } else if (mirror.isNumber()) {
                df = this.format.getNumberFormat();
            }
        }
        if (df != null) {
            if (df instanceof DateFormat) {
                return this.doDateFormat((Date)value, (DateFormat)df);
            }
            return df.format(value);
        }
        return value.toString();
    }

    protected void doIntent() throws IOException {
        int idt = this.format.getIndent();
        for (int i = 0; i < idt; ++i) {
            this.writer.write(this.format.getIndentBy());
        }
    }

    protected void appendNull() throws IOException {
        if (this.format.isNullAsEmtry()) {
            this.writer.write("\"\"");
        } else {
            this.writer.write("null");
        }
    }

    protected String doDateFormat(Date date, DateFormat df) {
        if (df == null) {
            df = this.format.getDateFormat();
        }
        if (df != null) {
            if (this.format.getTimeZone() != null) {
                df.setTimeZone(this.format.getTimeZone());
            }
            return df.format(date);
        }
        return null;
    }

    static class Pair {
        String name;
        Object value;

        public Pair(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

