/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.java;

import org.nutz.ioc.java.BooleanNode;
import org.nutz.ioc.java.ChainNode;
import org.nutz.ioc.java.FieldNode;
import org.nutz.ioc.java.IocContextNode;
import org.nutz.ioc.java.IocObjectNameNode;
import org.nutz.ioc.java.IocObjectNode;
import org.nutz.ioc.java.IocSelfNode;
import org.nutz.ioc.java.NullNode;
import org.nutz.ioc.java.NumberNode;
import org.nutz.ioc.java.ObjectFunctionNode;
import org.nutz.ioc.java.StaticFunctionNode;
import org.nutz.ioc.java.StringNode;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.LinkedArray;
import org.nutz.lang.util.LinkedCharArray;

public class ChainParsing {
    private char[] cs;
    private int i;
    private ChainNode first;
    private ChainNode last;
    private LinkedArray<LinkedArray<ChainNode>> argss;
    private LinkedCharArray ends = new LinkedCharArray(10);
    private StringBuilder sb = new StringBuilder();
    private int recursiveCount = 0;

    public ChainParsing(String s) {
        this.argss = new LinkedArray(5);
        this.cs = s.toCharArray();
        this.parse();
    }

    private void parse() {
        ++this.recursiveCount;
        while (this.i < this.cs.length) {
            String name;
            String strNodes;
            char c = this.cs[this.i];
            if (c == ',') {
                this.checkIfNeedAddNode();
            } else if (null != this.first && c == '.') {
                String fn = this.clearStringBuffer();
                if (!Strings.isBlank(fn)) {
                    this.addNode(new FieldNode(fn));
                }
            } else if (c == '\'' || c == '\"') {
                char n;
                this.clearStringBuffer();
                ++this.i;
                while (this.i < this.cs.length && (n = this.cs[this.i]) != c) {
                    this.sb.append(n);
                    ++this.i;
                }
                this.addNode(new StringNode(this.clearStringBuffer()));
            } else if (c == '@') {
                if (this.recursiveCount > 1 && this.hasFieldOrFunction()) {
                    strNodes = "@" + this.readToComma();
                    this.addNode(new ChainParsing(strNodes).getNode());
                } else {
                    name = this.readToDot().toUpperCase();
                    if ("IOC".equals(name)) {
                        this.addNode(new IocSelfNode());
                    } else if ("CONTEXT".equals(name)) {
                        this.addNode(new IocContextNode());
                    } else if ("NAME".equals(name)) {
                        this.addNode(new IocObjectNameNode());
                    }
                }
            } else if (c == '$') {
                if (this.recursiveCount > 1 && this.hasFieldOrFunction()) {
                    strNodes = "$" + this.readToComma();
                    this.addNode(new ChainParsing(strNodes).getNode());
                } else {
                    name = this.readToDot();
                    this.addNode(new IocObjectNode(name));
                }
            } else if (c == '(') {
                String funcName = Strings.trim(this.clearStringBuffer());
                this.argss.push(new LinkedArray<ChainNode>(ChainNode.class, 5));
                this.ends.push(')');
                ++this.i;
                this.parse();
                this.ends.popLast();
                ChainNode[] args = this.argss.popLast().toArray();
                int pos = funcName.lastIndexOf(46);
                if (pos > 0) {
                    String className = funcName.substring(0, pos);
                    funcName = funcName.substring(pos + 1);
                    this.addNode(new StaticFunctionNode(className, funcName, args));
                } else if (pos == 0) {
                    this.addNode(new ObjectFunctionNode(funcName.substring(1), args));
                } else {
                    this.addNode(new ObjectFunctionNode(funcName, args));
                }
                this.clearStringBuffer();
            } else {
                if (this.ends.size() > 0 && c == this.ends.last()) {
                    this.checkIfNeedAddNode();
                    return;
                }
                if (c == ')' && this.i == this.cs.length - 1) {
                    return;
                }
                this.sb.append(c);
            }
            ++this.i;
        }
        --this.recursiveCount;
        this.checkIfNeedAddNode();
    }

    private boolean hasFieldOrFunction() {
        int dot = 0;
        int comma = 0;
        for (int currentIndex = this.i; currentIndex < this.cs.length; ++currentIndex) {
            char c = this.cs[currentIndex];
            if (c == '.') {
                dot = currentIndex;
            }
            if (c != ',') continue;
            comma = currentIndex;
        }
        return dot < comma || dot != 0 && comma == 0;
    }

    private void checkIfNeedAddNode() {
        if (!Strings.isBlank(this.sb)) {
            String s = Strings.trim(this.clearStringBuffer());
            if (s.equalsIgnoreCase("null")) {
                this.addNode(new NullNode());
            } else if (s.matches("^(true|false)$")) {
                this.addNode(new BooleanNode(s));
            } else if (s.matches("^([-]?[0-9]+)?([.][0-9]+)?([fL]?)$")) {
                this.addNode(new NumberNode(s));
            } else if (null == this.last) {
                int pos = s.lastIndexOf(46);
                if (pos < 0) {
                    throw Lang.makeThrow("Don't know how to invoke '%s'", s);
                }
                String className = s.substring(0, pos);
                String funcName = s.substring(pos + 1);
                this.addNode(new StaticFunctionNode(className, funcName, new ChainNode[0]));
            } else {
                this.addNode(new FieldNode(s));
            }
        }
    }

    private String readToDot() {
        char c;
        ++this.i;
        while (this.i < this.cs.length && (c = this.cs[this.i]) != '.' && c != ',') {
            this.sb.append(c);
            ++this.i;
        }
        return this.clearStringBuffer();
    }

    private String readToComma() {
        char c;
        ++this.i;
        while (this.i < this.cs.length && (c = this.cs[this.i]) != ',' && c != ')') {
            this.sb.append(c);
            ++this.i;
        }
        return this.clearStringBuffer();
    }

    private String clearStringBuffer() {
        String re = Strings.trim(this.sb);
        this.sb = new StringBuilder();
        return re;
    }

    private void addNode(ChainNode node) {
        if (this.argss.size() > 0) {
            this.argss.last().push(node);
        } else if (this.last == null) {
            this.first = node;
            this.last = node;
        } else {
            this.last.setNext(node);
            this.last = node;
        }
    }

    public ChainNode getNode() {
        return this.first;
    }
}

