/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc;

import java.util.List;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocContext;
import org.nutz.ioc.ObjectMaker;
import org.nutz.ioc.ValueProxy;
import org.nutz.ioc.ValueProxyMaker;
import org.nutz.ioc.aop.MirrorFactory;
import org.nutz.ioc.meta.IocValue;
import org.nutz.json.Json;
import org.nutz.lang.Lang;

public class IocMaking {
    private String objectName;
    private ObjectMaker objectMaker;
    private Ioc ioc;
    private IocContext context;
    private List<ValueProxyMaker> vpms;
    private MirrorFactory mirrors;

    public IocMaking(Ioc ioc, MirrorFactory mirrors, IocContext context, ObjectMaker maker, List<ValueProxyMaker> vpms, String objName) {
        this.objectName = objName;
        this.objectMaker = maker;
        this.ioc = ioc;
        this.context = context;
        this.vpms = vpms;
        this.mirrors = mirrors;
    }

    public Ioc getIoc() {
        return this.ioc;
    }

    public IocContext getContext() {
        return this.context;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public ObjectMaker getObjectMaker() {
        return this.objectMaker;
    }

    public MirrorFactory getMirrors() {
        return this.mirrors;
    }

    public IocMaking clone(String objectName) {
        return new IocMaking(this.ioc, this.mirrors, this.context, this.objectMaker, this.vpms, objectName);
    }

    public ValueProxy makeValue(IocValue iv) {
        for (ValueProxyMaker vpm : this.vpms) {
            ValueProxy vp = vpm.make(this, iv);
            if (null == vp) continue;
            return vp;
        }
        throw Lang.makeThrow("Unknown value {'%s':%s} for object [%s]", iv.getType(), Json.toJson(iv.getValue()), this.objectName);
    }
}

