/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc.psql;

import java.sql.Blob;
import java.util.List;
import org.nutz.dao.DB;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.impl.jdbc.AbstractJdbcExpert;
import org.nutz.dao.impl.jdbc.BlobValueAdaptor2;
import org.nutz.dao.impl.jdbc.psql.PsqlArrayAdaptor;
import org.nutz.dao.impl.jdbc.psql.PsqlJsonAdaptor;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.util.Pojos;
import org.nutz.lang.Lang;

public class PsqlJdbcExpert
extends AbstractJdbcExpert {
    public PsqlJdbcExpert(JdbcExpertConfigFile conf) {
        super(conf);
    }

    @Override
    public String getDatabaseType() {
        return DB.PSQL.name();
    }

    @Override
    public void formatQuery(Pojo pojo) {
        Pager pager = pojo.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            pojo.append(Pojos.Items.wrapf(" LIMIT %d OFFSET %d", pager.getPageSize(), pager.getOffset()));
        }
    }

    @Override
    public void formatQuery(Sql sql) {
        Pager pager = sql.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            sql.setSourceSql(sql.getSourceSql() + String.format(" LIMIT %d OFFSET %d", pager.getPageSize(), pager.getOffset()));
        }
    }

    @Override
    public boolean createEntity(Dao dao, Entity<?> en) {
        StringBuilder sb = new StringBuilder("CREATE TABLE " + en.getTableName() + "(");
        for (MappingField mf : en.getMappingFields()) {
            if (mf.isReadonly()) continue;
            sb.append('\n').append(mf.getColumnNameInSql());
            if (mf.isId() && mf.isAutoIncreasement()) {
                sb.append(" SERIAL");
            } else {
                sb.append(' ').append(this.evalFieldType(mf));
                if (mf.isName() && en.getPkType() != PkType.NAME) {
                    sb.append(" UNIQUE NOT NULL");
                } else {
                    if (mf.isUnsigned()) {
                        sb.append(" UNSIGNED");
                    }
                    if (mf.isNotNull()) {
                        sb.append(" NOT NULL");
                    }
                    if (mf.isAutoIncreasement()) {
                        throw Lang.noImplement();
                    }
                    if (mf.hasDefaultValue()) {
                        this.addDefaultValue(sb, mf);
                    }
                }
            }
            sb.append(',');
        }
        List<MappingField> pks = en.getPks();
        if (!pks.isEmpty()) {
            sb.append('\n');
            sb.append(String.format("CONSTRAINT %s_pkey PRIMARY KEY (", en.getTableName().replace('.', '_').replace('\"', '_')));
            for (MappingField pk : pks) {
                sb.append(pk.getColumnNameInSql()).append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            sb.append("\n ");
        }
        sb.setCharAt(sb.length() - 1, ')');
        dao.execute(Sqls.create(sb.toString()));
        dao.execute(this.createIndexs(en).toArray(new Sql[0]));
        this.createRelation(dao, en);
        this.addComment(dao, en);
        return true;
    }

    @Override
    public String evalFieldType(MappingField mf) {
        if (mf.getCustomDbType() != null) {
            return mf.getCustomDbType();
        }
        switch (mf.getColumnType()) {
            case INT: {
                if (mf.getWidth() > 0) {
                    return "NUMERIC(" + mf.getWidth() + ")";
                }
                return "INT";
            }
            case FLOAT: {
                if (mf.getWidth() > 0 && mf.getPrecision() > 0) {
                    return "NUMERIC(" + mf.getWidth() + "," + mf.getPrecision() + ")";
                }
                if (mf.getTypeMirror().isDouble()) {
                    return "NUMERIC(15,10)";
                }
                return "NUMERIC";
            }
            case BINARY: {
                return "BYTEA";
            }
            case DATETIME: {
                return "TIMESTAMP";
            }
            case PSQL_JSON: {
                return "JSON";
            }
            case PSQL_ARRAY: {
                return "ARRAY";
            }
        }
        return super.evalFieldType(mf);
    }

    @Override
    protected String createResultSetMetaSql(Entity<?> en) {
        return "SELECT * FROM " + en.getViewName() + " LIMIT 1";
    }

    @Override
    public ValueAdaptor getAdaptor(MappingField ef) {
        if (ef.getTypeMirror().isOf(Blob.class)) {
            return new BlobValueAdaptor2(Jdbcs.getFilePool());
        }
        if (ColType.PSQL_JSON == ef.getColumnType()) {
            return new PsqlJsonAdaptor();
        }
        if (ColType.PSQL_ARRAY == ef.getColumnType()) {
            return new PsqlArrayAdaptor(ef.getCustomDbType());
        }
        return super.getAdaptor(ef);
    }

    @Override
    public String wrapKeywork(String columnName, boolean force) {
        if (force || this.keywords.contains(columnName.toUpperCase())) {
            return "\"" + columnName + "\"";
        }
        return null;
    }
}

