/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity;

import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.NutEntity;
import org.nutz.dao.impl.entity.field.NutMappingField;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.lang.Mirror;
import org.nutz.lang.eject.EjectFromMap;
import org.nutz.lang.inject.InjectToMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class MapEntityMaker {
    private static final Log log = Logs.get();
    protected JdbcExpert expert;
    protected DataSource dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Map<String, ?>> Entity<T> make(String tableName, T map) {
        NutEntity en = new NutEntity(map.getClass());
        en.setTableName(tableName);
        en.setViewName(tableName);
        boolean check = false;
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("#")) {
                en.getMetas().put(key.substring(1), entry.getValue().toString());
                continue;
            }
            if (key.startsWith(".")) continue;
            Object value = entry.getValue();
            Mirror<?> mirror = Mirror.me(value);
            NutMappingField ef = new NutMappingField(en);
            while (true) {
                if (key.startsWith("+")) {
                    ef.setAsAutoIncreasement();
                    if (mirror != null && mirror.isIntLike()) {
                        ef.setAsId();
                    }
                    key = key.substring(1);
                    continue;
                }
                if (key.startsWith("!")) {
                    ef.setAsNotNull();
                    key = key.substring(1);
                    continue;
                }
                if (!key.startsWith("*")) break;
                key = key.substring(1);
                if (mirror != null && mirror.isIntLike()) {
                    ef.setAsId();
                    continue;
                }
                ef.setAsName();
            }
            ef.setName(key);
            ef.setColumnName(key);
            if (map.containsKey("." + key + ".type")) {
                ef.setType((Class)map.get("." + key + ".type"));
            } else {
                ef.setType((Type)((Object)(null == value ? Object.class : value.getClass())));
            }
            if (map.containsKey("." + key + ".coltype")) {
                ef.setColumnType((ColType)((Object)map.get("." + key + ".coltype")));
            } else {
                Jdbcs.guessEntityFieldColumnType(ef);
            }
            if (map.containsKey("." + key + ".adaptor")) {
                ef.setAdaptor((ValueAdaptor)map.get("." + key + ".adapter"));
            } else {
                ef.setAdaptor(this.expert.getAdaptor(ef));
            }
            ef.setInjecting(new InjectToMap(key));
            ef.setEjecting(new EjectFromMap(entry.getKey()));
            if (ef.isAutoIncreasement() && ef.isId() && this.expert.isSupportAutoIncrement() && !this.expert.isSupportGeneratedKeys()) {
                en.addAfterInsertMacro(this.expert.fetchPojoId(en, ef));
            }
            en.addMappingField(ef);
            if (mirror == null || check) continue;
            check = mirror.isEnum();
        }
        en.checkCompositeFields(null);
        if (check) {
            Connection conn = null;
            try {
                try {
                    conn = this.dataSource.getConnection();
                    this.expert.setupEntityField(conn, en);
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            catch (SQLException e) {
                log.debug(e.getMessage(), e);
            }
        }
        return en;
    }

    public void init(DataSource datasource, JdbcExpert expert, EntityHolder holder) {
        this.expert = expert;
        this.dataSource = datasource;
    }
}

