/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao;

import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.nutz.lang.Strings;

public class FieldMatcher {
    private Pattern actived;
    private Pattern locked;
    private boolean ignoreNull = true;
    private boolean ignoreBlankStr;
    private boolean ignoreZero = true;
    private boolean ignoreDate;
    private boolean ignoreId = true;
    private boolean ignoreName;
    private boolean ignorePk;

    public static FieldMatcher make(String actived, String locked, boolean ignoreNull) {
        FieldMatcher fm = new FieldMatcher();
        fm.ignoreNull = ignoreNull;
        if (!Strings.isBlank(actived)) {
            fm.actived = Pattern.compile(actived);
        }
        if (!Strings.isBlank(locked)) {
            fm.locked = Pattern.compile(locked);
        }
        return fm;
    }

    public static FieldMatcher create(boolean ignoreId) {
        FieldMatcher fm = new FieldMatcher();
        fm.ignoreId = ignoreId;
        return fm;
    }

    public static FieldMatcher make(String actived, String locked, boolean ignoreNull, boolean ignoreZero, boolean ignoreDate, boolean ignoreId, boolean ignoreName, boolean ignorePk) {
        FieldMatcher fm = FieldMatcher.make(actived, locked, ignoreNull);
        fm.ignoreZero = ignoreZero;
        fm.ignoreDate = ignoreDate;
        fm.ignoreId = ignoreId;
        fm.ignoreName = ignoreName;
        fm.ignorePk = ignorePk;
        return fm;
    }

    public static FieldMatcher make(String actived, String locked, boolean ignoreNull, boolean ignoreZero, boolean ignoreDate, boolean ignoreId, boolean ignoreName, boolean ignorePk, boolean ignoreBlankStr) {
        FieldMatcher fm = FieldMatcher.make(actived, locked, ignoreNull);
        fm.ignoreZero = ignoreZero;
        fm.ignoreDate = ignoreDate;
        fm.ignoreId = ignoreId;
        fm.ignoreName = ignoreName;
        fm.ignorePk = ignorePk;
        fm.ignoreBlankStr = ignoreBlankStr;
        return fm;
    }

    public boolean match(String str) {
        if (null != this.locked && this.locked.matcher(str).find()) {
            return false;
        }
        return null == this.actived || this.actived.matcher(str).find();
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public FieldMatcher setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
        return this;
    }

    public Pattern getActived() {
        return this.actived;
    }

    public Pattern getLocked() {
        return this.locked;
    }

    public FieldMatcher setActived(String actived) {
        this.actived = actived != null ? Pattern.compile(actived) : null;
        return this;
    }

    public FieldMatcher setLocked(String locked) {
        this.locked = locked != null ? Pattern.compile(locked) : null;
        return this;
    }

    public boolean isIgnoreZero() {
        return this.ignoreZero;
    }

    public FieldMatcher setIgnoreZero(boolean ignoreZero) {
        this.ignoreZero = ignoreZero;
        return this;
    }

    public boolean isIgnoreDate() {
        return this.ignoreDate;
    }

    public FieldMatcher setIgnoreDate(boolean ignoreDate) {
        this.ignoreDate = ignoreDate;
        return this;
    }

    public boolean isIgnoreId() {
        return this.ignoreId;
    }

    public FieldMatcher setIgnoreId(boolean ignoreId) {
        this.ignoreId = ignoreId;
        return this;
    }

    public boolean isIgnoreName() {
        return this.ignoreName;
    }

    public FieldMatcher setIgnoreName(boolean ignoreName) {
        this.ignoreName = ignoreName;
        return this;
    }

    public boolean isIgnorePk() {
        return this.ignorePk;
    }

    public FieldMatcher setIgnorePk(boolean ignorePk) {
        this.ignorePk = ignorePk;
        return this;
    }

    public boolean isIgnoreBlankStr() {
        return this.ignoreBlankStr;
    }

    public FieldMatcher setIgnoreBlankStr(boolean ignoreBlankStr) {
        this.ignoreBlankStr = ignoreBlankStr;
        return this;
    }

    public static FieldMatcher simple(String ... fields) {
        final HashSet<String> m = new HashSet<String>(Arrays.asList(fields));
        return new FieldMatcher(){

            @Override
            public boolean match(String str) {
                return m.contains(str);
            }
        };
    }
}

