/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.mapdb.CompressLZF;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.EncryptionXTEA;
import org.mapdb.Engine;
import org.mapdb.Serializer;
import org.mapdb.Volume;

public abstract class Store
implements Engine {
    protected static final Logger LOG = Logger.getLogger(Store.class.getName());
    protected static final long FEAT_COMP_LZF = 63L;
    protected static final long FEAT_ENC_XTEA = 62L;
    protected static final long FEAT_CRC = 61L;
    protected static final long HEAD_CHECKSUM = 4L;
    protected static final long HEAD_FEATURES = 8L;
    protected final ReentrantLock structuralLock = new ReentrantLock(false);
    protected final ReentrantLock commitLock = new ReentrantLock(false){

        @Override
        public void lock() {
            this.check();
            super.lock();
        }

        @Override
        public void unlock() {
            super.unlock();
            this.check();
        }

        private void check() {
            if (Store.this.structuralLock.isHeldByCurrentThread()) {
                throw new AssertionError((Object)"Can not lock commitLock, structuralLock already locked");
            }
            for (ReadWriteLock l : Store.this.locks) {
                if (!(l instanceof ReentrantReadWriteLock)) {
                    return;
                }
                if (((ReentrantReadWriteLock)l).isWriteLockedByCurrentThread()) {
                    throw new AssertionError((Object)"Current thread holds WriteLock, can not lock CommitLock");
                }
            }
        }
    };
    protected final ReadWriteLock[] locks;
    protected final int lockScale;
    protected final int lockMask;
    protected volatile boolean closed = false;
    protected final boolean readonly;
    protected final String fileName;
    protected final Volume.VolumeFactory volumeFactory;
    protected final boolean checksum;
    protected final boolean compress;
    protected final boolean encrypt;
    protected final EncryptionXTEA encryptionXTEA;
    protected final ThreadLocal<CompressLZF> LZF;
    protected final boolean snapshotEnable;
    protected final boolean fileLockDisable;
    protected final AtomicLong metricsDataWrite;
    protected final AtomicLong metricsRecordWrite;
    protected final AtomicLong metricsDataRead;
    protected final AtomicLong metricsRecordRead;
    protected final boolean deserializeExtra;
    protected DataIO.HeartbeatFileLock fileLockHeartbeat;
    protected final Cache[] caches;
    public static final int LOCKING_STRATEGY_READWRITELOCK = 0;
    public static final int LOCKING_STRATEGY_WRITELOCK = 1;
    public static final int LOCKING_STRATEGY_NOLOCK = 2;
    protected final AtomicReference<DataIO.DataOutputByteArray> recycledDataOut = new AtomicReference();
    public static final Lock NOLOCK = new Lock(){

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    };

    protected Store(String fileName, Volume.VolumeFactory volumeFactory, Cache cache, int lockScale, int lockingStrategy, boolean checksum, boolean compress, byte[] password, boolean readonly, boolean snapshotEnable, boolean fileLockDisable, DataIO.HeartbeatFileLock fileLockHeartbeat) {
        int i;
        this.fileName = fileName;
        this.volumeFactory = volumeFactory;
        this.lockScale = lockScale;
        this.snapshotEnable = snapshotEnable;
        this.lockMask = lockScale - 1;
        this.fileLockDisable = fileLockDisable;
        this.fileLockHeartbeat = fileLockHeartbeat;
        if (fileLockHeartbeat != null) {
            fileLockHeartbeat.setQuitAfterGCed(this);
        }
        if (Integer.bitCount(lockScale) != 1) {
            throw new IllegalArgumentException("Lock Scale must be power of two");
        }
        this.metricsDataWrite = new AtomicLong();
        this.metricsRecordWrite = new AtomicLong();
        this.metricsDataRead = new AtomicLong();
        this.metricsRecordRead = new AtomicLong();
        this.locks = new ReadWriteLock[lockScale];
        for (i = 0; i < this.locks.length; ++i) {
            if (lockingStrategy == 0) {
                this.locks[i] = new ReentrantReadWriteLock(false);
                continue;
            }
            if (lockingStrategy == 1) {
                this.locks[i] = new ReadWriteSingleLock(new ReentrantLock(false));
                continue;
            }
            if (lockingStrategy == 2) {
                this.locks[i] = new ReadWriteSingleLock(NOLOCK);
                continue;
            }
            throw new IllegalArgumentException("Illegal locking strategy: " + lockingStrategy);
        }
        if (cache == null) {
            this.caches = null;
        } else {
            this.caches = new Cache[lockScale];
            this.caches[0] = cache;
            for (i = 1; i < this.caches.length; ++i) {
                this.caches[i] = cache.newCacheForOtherSegment();
            }
        }
        this.checksum = checksum;
        this.compress = compress;
        this.encrypt = password != null;
        this.deserializeExtra = this.checksum || this.encrypt || this.compress;
        this.readonly = readonly;
        this.encryptionXTEA = !this.encrypt ? null : new EncryptionXTEA(password);
        this.LZF = !compress ? null : new ThreadLocal<CompressLZF>(){

            @Override
            protected CompressLZF initialValue() {
                return new CompressLZF();
            }
        };
    }

    public void init() {
    }

    protected void checkFeaturesBitmap(long feat) {
        boolean crc;
        boolean lzwComp;
        boolean xteaEnc;
        boolean bl = xteaEnc = (feat >>> 62 & 1L) != 0L;
        if (xteaEnc && !this.encrypt) {
            throw new DBException.WrongConfig("Store was created with encryption, but no password is set in config.");
        }
        if (!xteaEnc && this.encrypt) {
            throw new DBException.WrongConfig("Password is set, but store is not encrypted.");
        }
        boolean bl2 = lzwComp = (feat >>> 63 & 1L) != 0L;
        if (lzwComp && !this.compress) {
            throw new DBException.WrongConfig("Store was created with compression, but no compression is enabled in config.");
        }
        if (!lzwComp && this.compress) {
            throw new DBException.WrongConfig("Compression is set in config, but store was created with compression.");
        }
        boolean bl3 = crc = (feat >>> 61 & 1L) != 0L;
        if (crc && !this.checksum) {
            throw new DBException.WrongConfig("Store was created with CRC32 checksum, but it is not enabled in config.");
        }
        if (!crc && this.checksum) {
            throw new DBException.WrongConfig("Checksum us enabled, but store was created without it.");
        }
        int endZeroes = Long.numberOfTrailingZeros(feat);
        if ((long)endZeroes < 61L) {
            throw new DBException.WrongConfig("Unknown feature #" + endZeroes + ". Store was created with never MapDB version, this version does not support this feature.");
        }
    }

    protected long makeFeaturesBitmap() {
        return (this.compress ? Long.MIN_VALUE : 0L) | (this.encrypt ? 0x4000000000000000L : 0L) | (this.checksum ? 0x2000000000000000L : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new IllegalAccessError("closed");
        }
        int lockPos = this.lockPos(recid);
        Lock lock = this.locks[lockPos].readLock();
        Cache cache = this.caches == null ? null : this.caches[lockPos];
        lock.lock();
        try {
            Object o;
            Object object = o = cache == null ? null : cache.get(recid);
            if (o != null) {
                if (o == Cache.NULL) {
                    o = null;
                }
                Object object2 = o;
                return (A)object2;
            }
            o = this.get2(recid, serializer);
            if (cache != null) {
                cache.put(recid, o);
            }
            Object object3 = o;
            return (A)object3;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract <A> A get2(long var1, Serializer<A> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new IllegalAccessError("closed");
        }
        DataIO.DataOutputByteArray out = this.serialize(value, serializer);
        int lockPos = this.lockPos(recid);
        Lock lock = this.locks[lockPos].writeLock();
        Cache cache = this.caches == null ? null : this.caches[lockPos];
        lock.lock();
        try {
            if (cache != null) {
                cache.put(recid, value);
            }
            this.update2(recid, out);
        }
        finally {
            lock.unlock();
        }
    }

    protected <A> DataIO.DataOutputByteArray serialize(A value, Serializer<A> serializer) {
        if (value == null) {
            return null;
        }
        try {
            DataIO.DataOutputByteArray out = this.newDataOut2();
            serializer.serialize(out, value);
            if (out.pos > 0) {
                if (this.compress) {
                    int newLen;
                    DataIO.DataOutputByteArray tmp = this.newDataOut2();
                    tmp.ensureAvail(out.pos + 40);
                    CompressLZF lzf = this.LZF.get();
                    try {
                        newLen = lzf.compress(out.buf, out.pos, tmp.buf, 0);
                    }
                    catch (IndexOutOfBoundsException e) {
                        newLen = 0;
                    }
                    if (newLen >= out.pos) {
                        newLen = 0;
                    }
                    if (newLen == 0) {
                        this.recycledDataOut.lazySet(tmp);
                        out.ensureAvail(out.pos + 1);
                        System.arraycopy(out.buf, 0, out.buf, 1, out.pos);
                        ++out.pos;
                        out.buf[0] = 0;
                    } else {
                        int decompSize = out.pos;
                        out.pos = 0;
                        DataIO.packInt(out, decompSize);
                        out.write(tmp.buf, 0, newLen);
                        this.recycledDataOut.lazySet(tmp);
                    }
                }
                if (this.encrypt) {
                    int size = out.pos;
                    if (size % 16 != 0) {
                        size += 16 - size % 16;
                    }
                    int sizeDif = size - out.pos;
                    out.ensureAvail(sizeDif + 1);
                    this.encryptionXTEA.encrypt(out.buf, 0, size);
                    out.pos = size;
                    out.writeByte(sizeDif);
                }
                if (this.checksum) {
                    CRC32 crc = new CRC32();
                    crc.update(out.buf, 0, out.pos);
                    out.writeInt((int)crc.getValue());
                }
            }
            this.metricsDataWrite.getAndAdd(out.pos);
            this.metricsRecordWrite.incrementAndGet();
            return out;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    protected DataIO.DataOutputByteArray newDataOut2() {
        DataIO.DataOutputByteArray tmp = this.recycledDataOut.getAndSet(null);
        if (tmp == null) {
            tmp = new DataIO.DataOutputByteArray();
        } else {
            tmp.pos = 0;
        }
        return tmp;
    }

    protected <A> A deserialize(Serializer<A> serializer, int size, DataInput input) {
        try {
            DataIO.DataInputInternal di = (DataIO.DataInputInternal)input;
            if (size > 0 && this.deserializeExtra) {
                return this.deserializeExtra(serializer, size, di);
            }
            if (!serializer.isTrusted() && !this.alreadyCopyedDataInput(input, size)) {
                DataIO.DataInputByteArray b = new DataIO.DataInputByteArray(new byte[size]);
                input.readFully(b.buf);
                input = b;
                di = b;
            }
            int start = di.getPos();
            A ret = serializer.deserialize(di, size);
            if (size + start > di.getPos()) {
                throw new DBException.DataCorruption("Data were not fully read, check your serializer. Read size:" + (di.getPos() - start) + ", expected size:" + size);
            }
            if (size + start < di.getPos()) {
                throw new DBException.DataCorruption("Data were read beyond record size, check your serializer. Read size:" + (di.getPos() - start) + ", expected size:" + size);
            }
            this.metricsDataRead.getAndAdd(size);
            this.metricsRecordRead.getAndIncrement();
            return ret;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private final boolean alreadyCopyedDataInput(DataInput input, int size) {
        if (!(input instanceof DataIO.DataInputByteArray)) {
            return false;
        }
        DataIO.DataInputByteArray input2 = (DataIO.DataInputByteArray)input;
        return input2.pos == 0 && input2.buf.length == size;
    }

    private <A> A deserializeExtra(Serializer<A> serializer, int size, DataIO.DataInputInternal di) throws IOException {
        DataIO.DataOutputByteArray tmp;
        if (this.checksum) {
            tmp = this.newDataOut2();
            tmp.ensureAvail(size -= 4);
            int oldPos = di.getPos();
            di.readFully(tmp.buf, 0, size);
            int checkExpected = di.readInt();
            di.setPos(oldPos);
            CRC32 crc = new CRC32();
            crc.update(tmp.buf, 0, size);
            this.recycledDataOut.lazySet(tmp);
            int check = (int)crc.getValue();
            if (check != checkExpected) {
                throw new IOException("Checksum does not match, data broken");
            }
        }
        if (this.encrypt) {
            tmp = this.newDataOut2();
            tmp.ensureAvail(--size);
            di.readFully(tmp.buf, 0, size);
            this.encryptionXTEA.decrypt(tmp.buf, 0, size);
            int cut = di.readUnsignedByte();
            di = new DataIO.DataInputByteArray(tmp.buf);
            size -= cut;
        }
        if (this.compress) {
            int decompSize = DataIO.unpackInt(di);
            if (decompSize == 0) {
                --size;
            } else {
                DataIO.DataOutputByteArray out = this.newDataOut2();
                out.ensureAvail(decompSize);
                CompressLZF lzf = this.LZF.get();
                byte[] b = di.internalByteArray();
                if (b != null) {
                    lzf.expand(b, di.getPos(), out.buf, 0, decompSize);
                } else {
                    ByteBuffer bb = di.internalByteBuffer();
                    if (bb != null) {
                        lzf.expand(bb, di.getPos(), out.buf, 0, decompSize);
                    } else {
                        lzf.expand(di, out.buf, 0, decompSize);
                    }
                }
                di = new DataIO.DataInputByteArray(out.buf);
                size = decompSize;
            }
        }
        int start = di.getPos();
        A ret = serializer.deserialize(di, size);
        if (size + start > di.getPos()) {
            throw new DBException.DataCorruption("Data were not fully read, check your serializer. Read size:" + (di.getPos() - start) + ", expected size:" + size);
        }
        if (size + start < di.getPos()) {
            throw new DBException.DataCorruption("Data were read beyond record size, check your serializer. Read size:" + (di.getPos() - start) + ", expected size:" + size);
        }
        return ret;
    }

    protected abstract void update2(long var1, DataIO.DataOutputByteArray var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new IllegalAccessError("closed");
        }
        int lockPos = this.lockPos(recid);
        Lock lock = this.locks[lockPos].writeLock();
        Cache cache = this.caches == null ? null : this.caches[lockPos];
        lock.lock();
        try {
            Object oldVal;
            Object object = oldVal = cache == null ? null : cache.get(recid);
            if (oldVal == null) {
                oldVal = this.get2(recid, serializer);
            } else if (oldVal == Cache.NULL) {
                oldVal = null;
            }
            if (oldVal == expectedOldValue || oldVal != null && serializer.equals(oldVal, expectedOldValue)) {
                this.update2(recid, this.serialize(newValue, serializer));
                if (cache != null) {
                    cache.put(recid, newValue);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        if (serializer == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new IllegalAccessError("closed");
        }
        int lockPos = this.lockPos(recid);
        Lock lock = this.locks[lockPos].writeLock();
        Cache cache = this.caches == null ? null : this.caches[lockPos];
        lock.lock();
        try {
            if (cache != null) {
                cache.put(recid, null);
            }
            this.delete2(recid, serializer);
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract <A> void delete2(long var1, Serializer<A> var3);

    protected final int lockPos(long recid) {
        int h = (int)(recid ^ recid >>> 32);
        h ^= h << 4;
        h ^= h << 4;
        h ^= h << 4;
        h ^= h << 4;
        h ^= h << 4;
        h ^= h << 4;
        h ^= h << 4;
        return h & this.lockMask;
    }

    protected void assertReadLocked(long recid) {
    }

    protected void assertWriteLocked(int segment) {
        ReadWriteLock l = this.locks[segment];
        if (l instanceof ReentrantReadWriteLock && !((ReentrantReadWriteLock)l).isWriteLockedByCurrentThread()) {
            throw new AssertionError();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    public static Store forDB(DB db) {
        return Store.forEngine(db.engine);
    }

    public static Store forEngine(Engine e) {
        Engine engine2 = e.getWrappedEngine();
        if (engine2 != null) {
            return Store.forEngine(engine2);
        }
        return (Store)e;
    }

    public abstract long getCurrSize();

    public abstract long getFreeSize();

    public abstract boolean fileLoad();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        if (this.closed) {
            throw new IllegalAccessError("closed");
        }
        if (this.caches == null) {
            return;
        }
        for (int i = 0; i < this.locks.length; ++i) {
            Lock lock = this.locks[i].readLock();
            lock.lock();
            try {
                this.caches[i].clear();
                continue;
            }
            finally {
                lock.unlock();
            }
        }
    }

    public void metricsCollect(Map<String, Long> map) {
        map.put("data.write", this.metricsDataWrite.getAndSet(0L));
        map.put("record.write", this.metricsRecordWrite.getAndSet(0L));
        map.put("data.read", this.metricsDataRead.getAndSet(0L));
        map.put("record.read", this.metricsRecordRead.getAndSet(0L));
        long cacheHit = 0L;
        long cacheMiss = 0L;
        if (this.caches != null) {
            for (Cache c : this.caches) {
                cacheHit += c.metricsCacheHit();
                cacheMiss += c.metricsCacheMiss();
            }
        }
        map.put("cache.hit", cacheHit);
        map.put("cache.miss", cacheMiss);
    }

    public abstract void backup(OutputStream var1, boolean var2);

    public abstract void backupRestore(InputStream[] var1);

    @Override
    public Engine getWrappedEngine() {
        return null;
    }

    @Override
    public boolean canSnapshot() {
        return this.snapshotEnable;
    }

    protected final long longParitySet(long value) {
        return this.checksum ? DataIO.parity16Set(value << 16) : DataIO.parity1Set(value << 1);
    }

    protected final long longParityGet(long value) {
        return this.checksum ? DataIO.parity16Get(value) >>> 16 : DataIO.parity1Get(value) >>> 1;
    }

    public static final class LongObjectObjectMap<V1, V2> {
        int size;
        int maxSize;
        long[] set;
        Object[] values;

        public LongObjectObjectMap() {
            this(32);
        }

        public LongObjectObjectMap(int initCapacity) {
            initCapacity = DataIO.nextPowTwo(initCapacity);
            this.set = new long[initCapacity];
            this.values = new Object[initCapacity * 2];
        }

        public int get(long key) {
            if (key == 0L) {
                throw new IllegalArgumentException("zero key");
            }
            int index = this.index(key);
            if (index >= 0) {
                return index;
            }
            return -1;
        }

        public V1 get1(long key) {
            if (key == 0L) {
                throw new IllegalArgumentException("zero key");
            }
            int index = this.index(key);
            if (index >= 0) {
                return (V1)this.values[index * 2];
            }
            return null;
        }

        public V2 get2(long key) {
            if (key == 0L) {
                throw new IllegalArgumentException("zero key");
            }
            int index = this.index(key);
            if (index >= 0) {
                return (V2)this.values[index * 2 + 1];
            }
            return null;
        }

        int index(long key) {
            if (key != 0L) {
                long[] keys = this.set;
                int capacityMask = keys.length - 1;
                int index = DataIO.longHash(key) & capacityMask;
                long cur = keys[index];
                if (cur == key) {
                    return index;
                }
                if (cur == 0L) {
                    return -1;
                }
                do {
                    if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                    return index;
                } while (cur != 0L);
                return -1;
            }
            return -1;
        }

        public int put(long key, V1 val1, V2 val2) {
            if (key == 0L) {
                throw new IllegalArgumentException("zero key");
            }
            int index = this.insert(key, val1, val2);
            if (index < 0) {
                return -1;
            }
            Object[] vals = this.values;
            vals[index * 2] = val1;
            vals[index * 2 + 1] = val2;
            return index;
        }

        int insert(long key, V1 val1, V2 val2) {
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = DataIO.longHash(key) & capacityMask;
            long cur = keys[index];
            if (cur != 0L) {
                if (cur == key) {
                    return index;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != 0L) {
                    if (cur != key) continue;
                    return index;
                }
            }
            keys[index] = key;
            this.values[index *= 2] = val1;
            this.values[index + 1] = val2;
            this.postInsertHook();
            return -1;
        }

        void postInsertHook() {
            int capacity;
            if (++this.size > this.maxSize && !LongLongMap.isMaxCapacity(capacity = this.set.length)) {
                this.rehash(capacity << 1);
            }
        }

        void rehash(int newCapacity) {
            long[] keys = this.set;
            Object[] vals = this.values;
            this.maxSize = LongLongMap.maxSize(newCapacity);
            this.set = new long[newCapacity];
            this.values = new Object[newCapacity * 2];
            long[] newKeys = this.set;
            int capacityMask = newKeys.length - 1;
            Object[] newVals = this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == 0L) continue;
                int index = DataIO.longHash(key) & capacityMask;
                if (newKeys[index] != 0L) {
                    while (newKeys[index = index - 1 & capacityMask] != 0L) {
                    }
                }
                newKeys[index] = key;
                newVals[index * 2] = vals[i * 2];
                newVals[index * 2 + 1] = vals[i * 2 + 1];
            }
        }

        public void clear() {
            this.size = 0;
            Arrays.fill(this.set, 0L);
            Arrays.fill(this.values, null);
        }

        public int remove(long key) {
            long keyToShift;
            int indexToRemove;
            if (key == 0L) {
                throw new IllegalArgumentException("zero key");
            }
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = DataIO.longHash(key) & capacityMask;
            long cur = keys[index];
            if (cur != key) {
                if (cur == 0L) {
                    return -1;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != 0L) continue;
                    return -1;
                }
            }
            Object[] vals = this.values;
            int val = index;
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0L) {
                if ((DataIO.longHash(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = 0L;
            vals[indexToRemove *= 2] = null;
            vals[indexToRemove + 1] = null;
            --this.size;
            return val;
        }
    }

    public static final class LongList {
        long[] array = new long[16];
        int size = 0;

        public int add(long val) {
            ++this.size;
            if (this.array.length == this.size) {
                this.array = Arrays.copyOf(this.array, this.array.length * 4);
            }
            this.array[this.size] = val;
            return this.size - 1;
        }
    }

    public static final class MemoryBarrierLessLock
    implements Lock {
        static final int WAIT_NANOS = 100;
        protected final AtomicLong lockedThread = new AtomicLong(Long.MAX_VALUE);

        @Override
        public void lock() {
            long hash = Thread.currentThread().hashCode();
            while (!this.lockedThread.compareAndSet(Long.MAX_VALUE, hash)) {
                LockSupport.parkNanos(100L);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            Thread currThread = Thread.currentThread();
            long hash = currThread.hashCode();
            while (!this.lockedThread.compareAndSet(Long.MAX_VALUE, hash)) {
                LockSupport.parkNanos(100L);
                if (!currThread.isInterrupted()) continue;
                throw new InterruptedException();
            }
        }

        @Override
        public boolean tryLock() {
            long hash = Thread.currentThread().hashCode();
            return this.lockedThread.compareAndSet(Long.MAX_VALUE, hash);
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            long time2;
            long hash = Thread.currentThread().hashCode();
            for (time2 = unit.toNanos(time); !this.lockedThread.compareAndSet(Long.MAX_VALUE, hash) && time2 > 0L; time2 -= 100L) {
                LockSupport.parkNanos(100L);
            }
            return time2 > 0L;
        }

        @Override
        public void unlock() {
            long hash = Thread.currentThread().hashCode();
            if (!this.lockedThread.compareAndSet(hash, Long.MAX_VALUE)) {
                throw new IllegalMonitorStateException("Can not unlock, current thread does not hold this lock");
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ReadWriteSingleLock
    implements ReadWriteLock {
        protected final Lock lock;

        public ReadWriteSingleLock(Lock lock) {
            this.lock = lock;
        }

        @Override
        public Lock readLock() {
            return this.lock;
        }

        @Override
        public Lock writeLock() {
            return this.lock;
        }
    }

    public static final class LongQueue {
        static final int MAX_PACKED_LEN = 10;
        protected int size;
        protected byte[] b;
        protected int start = 0;
        protected int end = 0;

        public LongQueue() {
            this(1023);
        }

        public LongQueue(int size) {
            this.size = size;
            this.b = new byte[size];
        }

        public long take() {
            byte v;
            if (this.start == this.end) {
                return Long.MIN_VALUE;
            }
            long ret = 0L;
            do {
                v = this.b[this.start];
                ++this.start;
                this.start %= this.size;
                ret = ret << 7 | (long)(v & 0x7F);
            } while (v < 0);
            return ret;
        }

        public boolean put(long value) {
            if (this.end < this.start && this.start - this.end <= 10) {
                return false;
            }
            if (this.start < this.end && this.start + this.size - this.end <= 10) {
                return false;
            }
            int shift = 63 - Long.numberOfLeadingZeros(value);
            shift -= shift % 7;
            while (shift != 0) {
                this.b[this.end] = (byte)(value >>> shift & 0x7FL | 0x80L);
                ++this.end;
                this.end %= this.size;
                shift -= 7;
            }
            this.b[this.end] = (byte)(value & 0x7FL);
            ++this.end;
            this.end %= this.size;
            return true;
        }

        public boolean isEmpty() {
            return this.start == this.end;
        }
    }

    public static final class LongObjectMap<V> {
        int size;
        int maxSize;
        long[] set;
        Object[] values;

        public LongObjectMap() {
            this(32);
        }

        public LongObjectMap(int initCapacity) {
            initCapacity = DataIO.nextPowTwo(initCapacity);
            this.set = new long[initCapacity];
            this.values = new Object[initCapacity];
        }

        public V get(long key) {
            if (key == 0L) {
                throw new IllegalArgumentException("zero key");
            }
            int index = this.index(key);
            if (index >= 0) {
                return (V)this.values[index];
            }
            return null;
        }

        int index(long key) {
            if (key != 0L) {
                long[] keys = this.set;
                int capacityMask = keys.length - 1;
                int index = DataIO.longHash(key) & capacityMask;
                long cur = keys[index];
                if (cur == key) {
                    return index;
                }
                if (cur == 0L) {
                    return -1;
                }
                do {
                    if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                    return index;
                } while (cur != 0L);
                return -1;
            }
            return -1;
        }

        public V put(long key, V value) {
            if (key == 0L) {
                throw new IllegalArgumentException("zero key");
            }
            int index = this.insert(key, value);
            if (index < 0) {
                return null;
            }
            Object[] vals = this.values;
            Object prevValue = vals[index];
            vals[index] = value;
            return (V)prevValue;
        }

        int insert(long key, V value) {
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = DataIO.longHash(key) & capacityMask;
            long cur = keys[index];
            if (cur != 0L) {
                if (cur == key) {
                    return index;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != 0L) {
                    if (cur != key) continue;
                    return index;
                }
            }
            keys[index] = key;
            this.values[index] = value;
            this.postInsertHook();
            return -1;
        }

        void postInsertHook() {
            int capacity;
            if (++this.size > this.maxSize && !LongLongMap.isMaxCapacity(capacity = this.set.length)) {
                this.rehash(capacity << 1);
            }
        }

        void rehash(int newCapacity) {
            long[] keys = this.set;
            Object[] vals = this.values;
            this.maxSize = LongLongMap.maxSize(newCapacity);
            this.set = new long[newCapacity];
            this.values = new Object[newCapacity];
            long[] newKeys = this.set;
            int capacityMask = newKeys.length - 1;
            Object[] newVals = this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == 0L) continue;
                int index = DataIO.longHash(key) & capacityMask;
                if (newKeys[index] != 0L) {
                    while (newKeys[index = index - 1 & capacityMask] != 0L) {
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }

        public void clear() {
            this.size = 0;
            Arrays.fill(this.set, 0L);
            Arrays.fill(this.values, null);
        }

        public V remove(long key) {
            long keyToShift;
            int indexToRemove;
            if (key == 0L) {
                throw new IllegalArgumentException("zero key");
            }
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = DataIO.longHash(key) & capacityMask;
            long cur = keys[index];
            if (cur != key) {
                if (cur == 0L) {
                    return null;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != 0L) continue;
                    return null;
                }
            }
            Object[] vals = this.values;
            Object val = vals[index];
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0L) {
                if ((DataIO.longHash(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = 0L;
            vals[indexToRemove] = null;
            --this.size;
            return (V)val;
        }

        public boolean putIfAbsent(long key, V value) {
            if (this.get(key) == null) {
                this.put(key, value);
                return true;
            }
            return false;
        }
    }

    public static final class LongLongMap {
        int size;
        int maxSize;
        long[] table;
        private static final int MAX_INT_CAPACITY = 0x40000000;

        public LongLongMap() {
            this(32);
        }

        public LongLongMap(int initCapacity) {
            initCapacity = DataIO.nextPowTwo(initCapacity) * 2;
            this.table = new long[initCapacity];
        }

        public long get(long key) {
            if (key == 0L) {
                throw new IllegalArgumentException("zero key");
            }
            int index = this.index(key);
            if (index >= 0) {
                return this.table[index + 1];
            }
            return 0L;
        }

        public long put(long key, long value) {
            if (key == 0L) {
                throw new IllegalArgumentException("zero key");
            }
            if (value == 0L) {
                throw new IllegalArgumentException("zero val");
            }
            int index = this.insert(key, value);
            if (index < 0) {
                return 0L;
            }
            long[] tab = this.table;
            long prevValue = tab[index + 1];
            tab[index + 1] = value;
            return prevValue;
        }

        int insert(long key, long value) {
            int capacity;
            if (key == 0L) {
                throw new IllegalArgumentException("zero key");
            }
            long[] tab = this.table;
            int capacityMask = tab.length - 2;
            int index = DataIO.longHash(key) & capacityMask;
            long cur = tab[index];
            if (cur != 0L) {
                if (cur == key) {
                    return index;
                }
                while ((cur = tab[index = index - 2 & capacityMask]) != 0L) {
                    if (cur != key) continue;
                    return index;
                }
            }
            tab[index] = key;
            tab[index + 1] = value;
            if (++this.size > this.maxSize && !LongLongMap.isMaxCapacity(capacity = this.table.length >> 1)) {
                this.rehash(capacity << 1);
            }
            return -1;
        }

        int index(long key) {
            if (key != 0L) {
                long[] tab = this.table;
                int capacityMask = tab.length - 2;
                int index = DataIO.longHash(key) & capacityMask;
                long cur = tab[index];
                if (cur == key) {
                    return index;
                }
                if (cur == 0L) {
                    return -1;
                }
                do {
                    if ((cur = tab[index = index - 2 & capacityMask]) != key) continue;
                    return index;
                } while (cur != 0L);
                return -1;
            }
            return -1;
        }

        public int size() {
            return this.size;
        }

        public void clear() {
            this.size = 0;
            Arrays.fill(this.table, 0L);
        }

        void rehash(int newCapacity) {
            long[] tab = this.table;
            if ((newCapacity & newCapacity - 1) != 0) {
                throw new AssertionError();
            }
            this.maxSize = LongLongMap.maxSize(newCapacity);
            long[] newTab = this.table = new long[newCapacity * 2];
            int capacityMask = newTab.length - 2;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == 0L) continue;
                int index = DataIO.longHash(key) & capacityMask;
                if (newTab[index] != 0L) {
                    while (newTab[index = index - 2 & capacityMask] != 0L) {
                    }
                }
                newTab[index] = key;
                newTab[index + 1] = tab[i + 1];
            }
        }

        static int maxSize(int capacity) {
            return !LongLongMap.isMaxCapacity(capacity) ? capacity / 2 : capacity - 1;
        }

        private static boolean isMaxCapacity(int capacity) {
            int maxCapacity = 0x40000000;
            return capacity == (maxCapacity >>= 1);
        }

        public LongLongMap clone() {
            LongLongMap ret = new LongLongMap();
            ret.maxSize = this.maxSize;
            ret.size = this.size;
            ret.table = (long[])this.table.clone();
            return ret;
        }

        public boolean putIfAbsent(long key, long value) {
            if (this.get(key) == 0L) {
                this.put(key, value);
                return true;
            }
            return false;
        }
    }

    public static abstract class Cache {
        protected final Lock lock;
        protected long cacheHitCounter = 0L;
        protected long cacheMissCounter = 0L;
        protected static final Object NULL = new Object();

        public Cache(boolean disableLocks) {
            this.lock = disableLocks ? null : new ReentrantLock(false);
        }

        public abstract Object get(long var1);

        public abstract void put(long var1, Object var3);

        public abstract void clear();

        public abstract void close();

        public abstract Cache newCacheForOtherSegment();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long metricsCacheHit() {
            Lock lock = this.lock;
            if (lock != null) {
                lock.lock();
            }
            try {
                long ret = this.cacheHitCounter;
                this.cacheHitCounter = 0L;
                long l = ret;
                return l;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long metricsCacheMiss() {
            Lock lock = this.lock;
            if (lock != null) {
                lock.lock();
            }
            try {
                long ret = this.cacheMissCounter;
                this.cacheMissCounter = 0L;
                long l = ret;
                return l;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }

        public static final class LRU
        extends Cache {
            protected final int cacheSize;
            protected final LinkedHashMap<Long, Object> items = new LinkedHashMap();

            public LRU(int cacheSize, boolean disableLocks) {
                super(disableLocks);
                this.cacheSize = cacheSize;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(long recid) {
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    Object ret = this.items.get(recid);
                    if (ret != null) {
                        ++this.cacheHitCounter;
                    } else {
                        ++this.cacheMissCounter;
                    }
                    Object object = ret;
                    return object;
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void put(long recid, Object item) {
                Lock lock;
                if (item == null) {
                    item = NULL;
                }
                if ((lock = this.lock) != null) {
                    lock.lock();
                }
                try {
                    this.items.put(recid, item);
                    int itemsSize = this.items.size();
                    if (itemsSize > this.cacheSize) {
                        Iterator<Map.Entry<Long, Object>> iter = this.items.entrySet().iterator();
                        while (itemsSize-- > this.cacheSize && iter.hasNext()) {
                            iter.next();
                            iter.remove();
                        }
                    }
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() {
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    this.items.clear();
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void close() {
                this.clear();
            }

            @Override
            public Cache newCacheForOtherSegment() {
                return new LRU(this.cacheSize, this.lock == null);
            }
        }

        public static final class HardRef
        extends Cache {
            protected static final int CHECK_EVERY_N = 65535;
            protected int counter;
            protected final LongObjectMap cache;
            protected final int initialCapacity;
            protected final ScheduledExecutorService executor;
            protected final long executorPeriod;

            public HardRef(int initialCapacity, boolean disableLocks, ScheduledExecutorService executor, long executorPeriod) {
                super(disableLocks);
                if (disableLocks && executor != null) {
                    throw new IllegalArgumentException("Executor can not be enabled with lock disabled");
                }
                this.initialCapacity = initialCapacity;
                this.cache = new LongObjectMap(initialCapacity);
                this.executor = executor;
                this.executorPeriod = executorPeriod;
                if (executor != null) {
                    executor.scheduleAtFixedRate(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Lock lock = HardRef.this.lock;
                            lock.lock();
                            try {
                                HardRef.this.checkFreeMem();
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                    }, executorPeriod, executorPeriod, TimeUnit.MILLISECONDS);
                }
            }

            private void checkFreeMem() {
                this.counter = 1;
                Runtime r = Runtime.getRuntime();
                long max = r.maxMemory();
                if (max == Long.MAX_VALUE) {
                    return;
                }
                double free = r.freeMemory();
                double total = r.totalMemory();
                if ((free += (double)max - total) < 1.0E7 || free * 4.0 < (double)max) {
                    this.cache.clear();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(long recid) {
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    Object item;
                    if (this.executor == null && (this.counter++ & 0xFFFF) == 0) {
                        this.checkFreeMem();
                    }
                    if ((item = this.cache.get(recid)) != null) {
                        ++this.cacheHitCounter;
                    } else {
                        ++this.cacheMissCounter;
                    }
                    Object v = item;
                    return v;
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void put(long recid, Object item) {
                Lock lock;
                if (item == null) {
                    item = NULL;
                }
                if ((lock = this.lock) != null) {
                    lock.lock();
                }
                try {
                    if (this.executor == null && (this.counter++ & 0xFFFF) == 0) {
                        this.checkFreeMem();
                    }
                    this.cache.put(recid, item);
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() {
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    this.cache.clear();
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void close() {
                this.clear();
            }

            @Override
            public Cache newCacheForOtherSegment() {
                return new HardRef(this.initialCapacity, this.lock == null, this.executor, this.executorPeriod);
            }
        }

        public static class WeakSoftRef
        extends Cache {
            protected ReferenceQueue<Object> queue = new ReferenceQueue();
            protected LongObjectMap<CacheItem> items = new LongObjectMap();
            protected static final int CHECK_EVERY_N = 65535;
            protected int counter = 0;
            protected final ScheduledExecutorService executor;
            protected final boolean useWeakRef;
            protected final long executorScheduledRate;

            public WeakSoftRef(boolean useWeakRef, boolean disableLocks, ScheduledExecutorService executor, long executorScheduledRate) {
                super(disableLocks);
                if (disableLocks && executor != null) {
                    throw new IllegalArgumentException("Lock can not be disabled with executor enabled");
                }
                this.useWeakRef = useWeakRef;
                this.executor = executor;
                this.executorScheduledRate = executorScheduledRate;
                if (executor != null) {
                    executor.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            WeakSoftRef.this.flushGCedLocked();
                        }
                    }, (long)((double)executorScheduledRate * Math.random()), executorScheduledRate, TimeUnit.MILLISECONDS);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(long recid) {
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    Object ret;
                    CacheItem item = this.items.get(recid);
                    if (item == null) {
                        ++this.cacheMissCounter;
                        ret = null;
                    } else {
                        ++this.cacheHitCounter;
                        ret = item.get();
                    }
                    if (this.executor == null && (this.counter++ & 0xFFFF) == 0) {
                        this.flushGCed();
                    }
                    Object object = ret;
                    return object;
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void put(long recid, Object item) {
                if (item == null) {
                    item = NULL;
                }
                CacheItem cacheItem = (CacheItem)((Object)(this.useWeakRef ? new CacheWeakItem<Object>(item, this.queue, recid) : new CacheSoftItem<Object>(item, this.queue, recid)));
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    CacheItem older = this.items.put(recid, cacheItem);
                    if (older != null) {
                        older.clear();
                    }
                    if (this.executor == null && (this.counter++ & 0xFFFF) == 0) {
                        this.flushGCed();
                    }
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() {
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    this.items.clear();
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    this.items.clear();
                    this.items = null;
                    this.flushGCed();
                    this.queue = null;
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Cache newCacheForOtherSegment() {
                return new WeakSoftRef(this.useWeakRef, this.lock == null, this.executor, this.executorScheduledRate);
            }

            protected void flushGCed() {
                if (this.lock != null && this.lock instanceof ReentrantLock && !((ReentrantLock)this.lock).isHeldByCurrentThread()) {
                    throw new AssertionError((Object)"Not locked by current thread");
                }
                this.counter = 1;
                CacheItem item = (CacheItem)((Object)this.queue.poll());
                while (item != null) {
                    long recid = item.getRecid();
                    CacheItem otherEntry = this.items.get(recid);
                    if (otherEntry != null && otherEntry.get() == null) {
                        this.items.remove(recid);
                    }
                    item = (CacheItem)((Object)this.queue.poll());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void flushGCedLocked() {
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    this.flushGCed();
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            protected static final class CacheSoftItem<A>
            extends SoftReference<A>
            implements CacheItem {
                final long recid;

                public CacheSoftItem(A referent, ReferenceQueue<A> q, long recid) {
                    super(referent, q);
                    this.recid = recid;
                }

                @Override
                public long getRecid() {
                    return this.recid;
                }
            }

            protected static final class CacheWeakItem<A>
            extends WeakReference<A>
            implements CacheItem {
                final long recid;

                public CacheWeakItem(A referent, ReferenceQueue<A> q, long recid) {
                    super(referent, q);
                    this.recid = recid;
                }

                @Override
                public long getRecid() {
                    return this.recid;
                }
            }

            protected static interface CacheItem {
                public long getRecid();

                public Object get();

                public void clear();
            }
        }

        public static final class HashTable
        extends Cache {
            protected final long[] recids;
            protected final Object[] items;
            protected final int cacheMaxSizeMask;

            public HashTable(int cacheMaxSize, boolean disableLocks) {
                super(disableLocks);
                cacheMaxSize = DataIO.nextPowTwo(cacheMaxSize);
                this.cacheMaxSizeMask = cacheMaxSize - 1;
                this.recids = new long[cacheMaxSize];
                this.items = new Object[cacheMaxSize];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(long recid) {
                int pos = this.pos(recid);
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    boolean hit;
                    boolean bl = hit = this.recids[pos] == recid;
                    if (hit) {
                        ++this.cacheHitCounter;
                        Object object = this.items[pos];
                        return object;
                    }
                    ++this.cacheMissCounter;
                    Object var6_6 = null;
                    return var6_6;
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void put(long recid, Object item) {
                if (item == null) {
                    item = NULL;
                }
                int pos = this.pos(recid);
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    this.recids[pos] = recid;
                    this.items[pos] = item;
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            protected int pos(long recid) {
                return DataIO.longHash(recid) & this.cacheMaxSizeMask;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() {
                Lock lock = this.lock;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    Arrays.fill(this.recids, 0L);
                    Arrays.fill(this.items, null);
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void close() {
                this.clear();
            }

            @Override
            public Cache newCacheForOtherSegment() {
                return new HashTable(this.recids.length, this.lock == null);
            }
        }
    }
}

