/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.commons.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.Preconditions;
import org.junit.gen5.commons.util.ReflectionUtils;

@API(value=API.Usage.Internal)
public final class AnnotationUtils {
    private static final Map<AnnotationCacheKey, Annotation> annotationCache = new ConcurrentHashMap<AnnotationCacheKey, Annotation>(256);

    private AnnotationUtils() {
    }

    public static boolean isAnnotated(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotation(element, annotationType).isPresent();
    }

    public static <A extends Annotation> Optional<A> findAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(element, annotationType, new HashSet<Annotation>());
    }

    private static <A extends Annotation> Optional<A> findAnnotation(AnnotatedElement element, Class<A> annotationType, Set<Annotation> visited) {
        Optional<A> metaAnnotation;
        Preconditions.notNull(annotationType, "annotationType must not be null");
        if (element == null) {
            return Optional.empty();
        }
        AnnotationCacheKey key = new AnnotationCacheKey(element, annotationType);
        Annotation annotation = annotationCache.get(key);
        if (annotation != null) {
            return Optional.of(annotation);
        }
        annotation = element.getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            annotationCache.put(key, annotation);
            return Optional.of(annotation);
        }
        for (Annotation candidateAnnotation : element.getDeclaredAnnotations()) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage(candidateAnnotation) || !visited.add(candidateAnnotation) || !(metaAnnotation = AnnotationUtils.findAnnotation(candidateAnnotation.annotationType(), annotationType, visited)).isPresent()) continue;
            annotationCache.put(key, (Annotation)metaAnnotation.get());
            return metaAnnotation;
        }
        annotation = element.getAnnotation(annotationType);
        if (annotation != null) {
            annotationCache.put(key, annotation);
            return Optional.of(annotation);
        }
        for (Annotation candidateAnnotation : element.getAnnotations()) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage(candidateAnnotation) || !visited.add(candidateAnnotation) || !(metaAnnotation = AnnotationUtils.findAnnotation(candidateAnnotation.annotationType(), annotationType, visited)).isPresent()) continue;
            annotationCache.put(key, (Annotation)metaAnnotation.get());
            return metaAnnotation;
        }
        return Optional.empty();
    }

    public static <A extends Annotation> List<A> findRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType) {
        return AnnotationUtils.findRepeatableAnnotations(element, annotationType, new HashSet<Annotation>());
    }

    private static <A extends Annotation> List<A> findRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType, Set<Annotation> visited) {
        List<A> metaAnnotations;
        Preconditions.notNull(annotationType, "annotationType must not be null");
        Class<? extends Annotation> containerTypeForRepeatable = annotationType.isAnnotationPresent(Repeatable.class) ? annotationType.getAnnotation(Repeatable.class).value() : null;
        Preconditions.notNull(containerTypeForRepeatable, "annotationType must be @Repeatable");
        if (element == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<Object> collectedAnnotations = new LinkedHashSet<Object>();
        for (Annotation candidateAnnotation : element.getDeclaredAnnotations()) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage(candidateAnnotation) || !visited.add(candidateAnnotation)) continue;
            if (candidateAnnotation.annotationType().equals(annotationType)) {
                collectedAnnotations.add(annotationType.cast(candidateAnnotation));
                continue;
            }
            if (candidateAnnotation.annotationType().equals(containerTypeForRepeatable)) {
                List<Annotation> containedAnnotations = Arrays.asList(element.getDeclaredAnnotationsByType(annotationType));
                collectedAnnotations.addAll(containedAnnotations);
                continue;
            }
            metaAnnotations = AnnotationUtils.findRepeatableAnnotations(candidateAnnotation.annotationType(), annotationType, visited);
            collectedAnnotations.addAll(metaAnnotations);
        }
        for (Annotation candidateAnnotation : element.getAnnotations()) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage(candidateAnnotation) || !visited.add(candidateAnnotation)) continue;
            metaAnnotations = AnnotationUtils.findRepeatableAnnotations(candidateAnnotation.annotationType(), annotationType, visited);
            collectedAnnotations.addAll(metaAnnotations);
        }
        return new ArrayList(collectedAnnotations);
    }

    public static List<Method> findAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationType, ReflectionUtils.MethodSortOrder sortOrder) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(annotationType, "annotationType must not be null");
        return ReflectionUtils.findMethods(clazz, method -> AnnotationUtils.isAnnotated(method, annotationType), sortOrder);
    }

    private static boolean isInJavaLangAnnotationPackage(Annotation annotation) {
        return annotation != null && annotation.annotationType().getName().startsWith("java.lang.annotation");
    }

    private static class AnnotationCacheKey
    implements Serializable {
        private static final long serialVersionUID = 4611807332019442648L;
        private final AnnotatedElement element;
        private final Class<? extends Annotation> annotationType;

        public AnnotationCacheKey(AnnotatedElement element, Class<? extends Annotation> annotationType) {
            this.element = element;
            this.annotationType = annotationType;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AnnotationCacheKey) {
                AnnotationCacheKey that = (AnnotationCacheKey)obj;
                return Objects.equals(this.element, that.element) && Objects.equals(this.annotationType, that.annotationType);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.element, this.annotationType);
        }
    }
}

