/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web.compression;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.web.compression.CompressionServletResponseWrapper;

public class CompressionFilter
implements Filter {
    static final ILog log = LogFactory.getLog(CompressionFilter.class);
    int compressionLevel = -1;
    int compressionStrategy = 0;
    private FilterConfig config = null;

    public void init(FilterConfig filterConfig) {
        this.config = filterConfig;
    }

    public void destroy() {
        this.config = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("CompressionFilterStarting");
        boolean supportCompression = false;
        if (request instanceof HttpServletRequest) {
            log.debug("CompressionFilterURI", ((HttpServletRequest)request).getRequestURI());
            String s = ((HttpServletRequest)request).getParameter("gzip");
            if ("false".equals(s)) {
                log.debug("CompressionFilterNotCompressing");
                chain.doFilter(request, response);
                return;
            }
            Enumeration e = ((HttpServletRequest)request).getHeaders("Accept-Encoding");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.indexOf("gzip") != -1) {
                    log.debug("CompressionFilterSupportsCompression");
                    supportCompression = true;
                    continue;
                }
                log.debug("CompressionFilterDoesNotSupportsCompression");
            }
        }
        if (!supportCompression) {
            log.debug("CompressionFilterCalledNotCompressing");
            chain.doFilter(request, response);
            return;
        }
        if (response instanceof HttpServletResponse) {
            CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper((HttpServletResponse)response, this.compressionLevel, this.compressionStrategy);
            log.debug("CompressionFilterCalledCompressing");
            try {
                chain.doFilter(request, (ServletResponse)wrappedResponse);
                Object var9_8 = null;
                wrappedResponse.finishResponse();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                wrappedResponse.finishResponse();
                throw throwable;
            }
            return;
        }
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public int getCompressionStrategy() {
        return this.compressionStrategy;
    }

    public void setCompressionStrategy(int compressionStrategy) {
        this.compressionStrategy = compressionStrategy;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.init(filterConfig);
    }

    public FilterConfig getFilterConfig() {
        return this.config;
    }
}

