/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ObjectUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.web.AbstractFilter;
import org.jumpmind.symmetric.web.ThrottledResponseWrapper;

public class ThrottleFilter
extends AbstractFilter
implements IBuiltInExtensionPoint {
    private static final ILog log = LogFactory.getLog(ThrottleFilter.class);
    private Long maxBps;
    private Long threshold;
    private Long checkPoint;
    private static final long DEFAULT_THRESHOLD = 8192L;
    private static final long DEFAULT_CHECK_POINT = 1024L;

    public boolean isContainerCompatible() {
        return true;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ThrottledResponseWrapper wrapper = new ThrottledResponseWrapper((HttpServletResponse)response);
        wrapper.setCheckPoint((Long)ObjectUtils.defaultIfNull((Object)this.checkPoint, (Object)1024L));
        wrapper.setMaxBps((Long)ObjectUtils.defaultIfNull((Object)this.maxBps, (Object)0L));
        wrapper.setThreshold((Long)ObjectUtils.defaultIfNull((Object)this.threshold, (Object)8192L));
        log.debug("ThrottleFilterStarting");
        chain.doFilter(request, (ServletResponse)wrapper);
        log.info("ThrottleFilterCompleted");
    }

    public void setMaxBps(Long maxBps) {
        this.maxBps = maxBps;
    }

    public void setThreshold(Long threshold) {
        this.threshold = threshold;
    }

    public void setCheckPoint(Long checkPoint) {
        this.checkPoint = checkPoint;
    }

    public Long getMaxBps() {
        return this.maxBps;
    }

    public Long getThreshold() {
        return this.threshold;
    }

    public Long getCheckPoint() {
        return this.checkPoint;
    }

    protected ILog getLog() {
        return log;
    }
}

