/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.web.AbstractServlet;
import org.jumpmind.symmetric.web.IServletExtension;
import org.jumpmind.symmetric.web.ServletUtils;
import org.springframework.context.ApplicationContext;

public class SymmetricServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;
    private static final ILog log = LogFactory.getLog(SymmetricServlet.class);
    private List<IServletExtension> servlets;

    protected ILog getLog() {
        return log;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servlets = new ArrayList<IServletExtension>();
        ApplicationContext ctx = ServletUtils.getApplicationContext(this.getServletContext());
        LinkedHashMap servletBeans = new LinkedHashMap();
        servletBeans.putAll(ctx.getBeansOfType(IServletExtension.class));
        if (ctx.getParent() != null) {
            servletBeans.putAll(ctx.getParent().getBeansOfType(IServletExtension.class));
        }
        for (Map.Entry servletEntry : servletBeans.entrySet()) {
            log.debug("ServletInitializing", servletEntry.getKey());
            IServletExtension extension = (IServletExtension)servletEntry.getValue();
            extension.getServlet().init(config);
            this.servlets.add(extension);
        }
        if (this.servlets.size() == 0) {
            log.error("ServletNoneFound");
        }
    }

    public void destroy() {
        for (IServletExtension extension : this.servlets) {
            extension.getServlet().destroy();
        }
    }

    protected Servlet findMatchingServlet(ServletRequest req, ServletResponse resp) {
        Servlet retVal = null;
        Iterator<IServletExtension> iterator = this.servlets.iterator();
        while (retVal == null && iterator.hasNext()) {
            IServletExtension extension = iterator.next();
            if (extension.isDisabled() || !this.matches(extension, req)) continue;
            retVal = extension.getServlet();
        }
        return retVal;
    }

    public boolean matches(IServletExtension ext, ServletRequest request) {
        boolean retVal = true;
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String uri = this.normalizeRequestUri(httpRequest);
            if (!ArrayUtils.isEmpty((Object[])ext.getUriPatterns())) {
                retVal = this.matchesUriPatterns(uri, ext.getUriPatterns());
            }
        }
        return retVal;
    }

    protected boolean matchesUriPatterns(String uri, String[] uriPatterns) {
        boolean retVal = false;
        for (int i = 0; !retVal && i < uriPatterns.length; ++i) {
            retVal = this.matchesUriPattern(uri, uriPatterns[i]);
        }
        return retVal;
    }

    protected boolean matchesUriPattern(String uri, String uriPattern) {
        boolean retVal = false;
        String path = StringUtils.defaultIfEmpty((String)uri, (String)"/");
        String pattern = StringUtils.defaultIfEmpty((String)uriPattern, (String)"/");
        if ("/".equals(pattern) || "/*".equals(pattern) || pattern.equals(path)) {
            retVal = true;
        } else {
            String[] patternParts = StringUtils.split((String)pattern, (String)"/");
            String[] pathParts = StringUtils.split((String)path, (String)"/");
            boolean matches = true;
            for (int i = 0; i < patternParts.length && i < pathParts.length && matches; ++i) {
                String patternPart = patternParts[i];
                matches = "*".equals(patternPart) || patternPart.equals(pathParts[i]);
            }
            retVal = matches;
        }
        return retVal;
    }

    protected String normalizeRequestUri(HttpServletRequest httpRequest) {
        String contextPath;
        String retVal = httpRequest.getRequestURI();
        if (retVal.startsWith(contextPath = httpRequest.getContextPath())) {
            retVal = retVal.substring(contextPath.length());
        }
        return retVal;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        Servlet servlet = this.findMatchingServlet(req, res);
        if (servlet != null) {
            try {
                servlet.service(req, res);
            }
            catch (IOException e) {
                this.logException(req, e, false);
            }
            catch (Exception e) {
                this.logException(req, e, true);
                if (!res.isCommitted() && res instanceof HttpServletResponse) {
                    ((HttpServletResponse)res).sendError(500);
                }
            }
        } else if (req instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)req;
            log.error("ServletNotFoundToHandleRequest", this.normalizeRequestUri(httpRequest));
        }
    }

    protected void logException(ServletRequest req, Exception ex, boolean isError) {
        String method;
        String nodeId = req.getParameter("nodeId");
        String externalId = req.getParameter("externalId");
        String address = req.getRemoteAddr();
        String hostName = req.getRemoteHost();
        String string = method = req instanceof HttpServletRequest ? ((HttpServletRequest)req).getMethod() : "";
        if (this.getLog().isErrorEnabled() && isError) {
            this.getLog().error("ServletProcessingFailedError", ex, method, externalId, nodeId, address, hostName);
        } else if (this.getLog().isWarnEnabled()) {
            this.getLog().warn("ServletProcessingFailedWarning", method, externalId, nodeId, address, hostName, ex.getMessage());
        }
    }
}

