/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.IExtensionPoint;
import org.jumpmind.symmetric.web.AbstractFilter;
import org.jumpmind.symmetric.web.ServletUtils;
import org.springframework.context.ApplicationContext;

public class SymmetricFilter
implements Filter {
    private static final ILog log = LogFactory.getLog(SymmetricFilter.class);
    private ServletContext servletContext;
    private List<Filter> filters;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        new SymmetricFilterChain(chain).doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        this.filters = new ArrayList<Filter>();
        ApplicationContext ctx = ServletUtils.getApplicationContext(this.getServletContext());
        LinkedHashMap filterBeans = new LinkedHashMap();
        filterBeans.putAll(ctx.getBeansOfType(Filter.class));
        if (ctx.getParent() != null) {
            filterBeans.putAll(ctx.getParent().getBeansOfType(Filter.class));
        }
        for (Map.Entry filterEntry : filterBeans.entrySet()) {
            Filter filter = (Filter)filterEntry.getValue();
            if (filter instanceof IExtensionPoint) {
                String filterKey = (String)filterEntry.getKey();
                log.debug("FilterInitializing", filterKey);
                filter.init(filterConfig);
                this.filters.add(filter);
                continue;
            }
            log.warn("FilterSkipping");
        }
    }

    public void destroy() {
        for (Filter filter : this.filters) {
            filter.destroy();
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    private class SymmetricFilterChain
    implements FilterChain {
        private FilterChain chain;
        private int index;

        public SymmetricFilterChain(FilterChain chain) {
            this.chain = chain;
            this.index = 0;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (!response.isCommitted()) {
                if (this.index < SymmetricFilter.this.filters.size()) {
                    Filter filter = (Filter)SymmetricFilter.this.filters.get(this.index++);
                    if (filter instanceof AbstractFilter) {
                        AbstractFilter builtinFilter = (AbstractFilter)filter;
                        if (!builtinFilter.isDisabled() && builtinFilter.matches(request)) {
                            builtinFilter.doFilter(request, response, this);
                        } else {
                            this.doFilter(request, response);
                        }
                    } else {
                        filter.doFilter(request, response, (FilterChain)this);
                    }
                } else {
                    this.chain.doFilter(request, response);
                }
            }
        }
    }
}

