/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.web.IServletResource;
import org.jumpmind.symmetric.web.ServletUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ServletResourceTemplate
implements IServletResource {
    protected ServletContext servletContext;
    private boolean disabled;
    protected String[] uriPatterns;
    protected IParameterService parameterService;

    public void init(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setUriPattern(String uriPattern) {
        this.uriPatterns = new String[]{uriPattern};
    }

    public void setUriPatterns(String[] uriPatterns) {
        this.uriPatterns = uriPatterns;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String[] getUriPatterns() {
        return this.uriPatterns;
    }

    protected boolean matchesUriPatterns(String uri) {
        boolean retVal = false;
        for (int i = 0; !retVal && i < this.uriPatterns.length; ++i) {
            retVal = this.matchesUriPattern(uri, this.uriPatterns[i]);
        }
        return retVal;
    }

    protected boolean matchesUriPattern(String uri, String uriPattern) {
        boolean retVal = false;
        String path = StringUtils.defaultIfEmpty((String)uri, (String)"/");
        String pattern = StringUtils.defaultIfEmpty((String)uriPattern, (String)"/");
        if ("/".equals(pattern) || "/*".equals(pattern) || pattern.equals(path)) {
            retVal = true;
        } else {
            String[] patternParts = StringUtils.split((String)pattern, (String)"/");
            String[] pathParts = StringUtils.split((String)path, (String)"/");
            boolean matches = true;
            for (int i = 0; i < patternParts.length && i < pathParts.length && matches; ++i) {
                String patternPart = patternParts[i];
                matches = "*".equals(patternPart) || patternPart.equals(pathParts[i]);
            }
            retVal = matches;
        }
        return retVal;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    public void destroy() {
    }

    public boolean matches(ServletRequest request) {
        boolean retVal = true;
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String uri = this.normalizeRequestUri(httpRequest);
            if (!ArrayUtils.isEmpty((Object[])this.uriPatterns)) {
                retVal = this.matchesUriPatterns(uri);
            }
        }
        return retVal;
    }

    protected String normalizeRequestUri(HttpServletRequest httpRequest) {
        String contextPath;
        String retVal = httpRequest.getRequestURI();
        if (retVal.startsWith(contextPath = httpRequest.getContextPath())) {
            retVal = retVal.substring(contextPath.length());
        }
        return retVal;
    }

    protected boolean sendError(ServletResponse resp, int statusCode) throws IOException {
        return ServletUtils.sendError(resp, statusCode);
    }

    protected boolean sendError(ServletResponse resp, int statusCode, String message) throws IOException {
        return ServletUtils.sendError(resp, statusCode, message);
    }

    protected ApplicationContext getDefaultApplicationContext() {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
    }

    public boolean isSpringManaged() {
        boolean managed = this.getDefaultApplicationContext().getBeansOfType(this.getClass()).values().contains(this);
        if (!managed && this.getDefaultApplicationContext().getParent() != null) {
            managed = this.getDefaultApplicationContext().getParent().getBeansOfType(this.getClass()).values().contains(this);
        }
        return managed;
    }

    public IServletResource getSpringBean() {
        IServletResource retVal = this;
        if (!this.isSpringManaged()) {
            Iterator iterator = this.getDefaultApplicationContext().getBeansOfType(this.getClass()).values().iterator();
            if (iterator.hasNext()) {
                retVal = (IServletResource)iterator.next();
            }
            if (retVal == null && this.getDefaultApplicationContext().getParent() != null && (iterator = this.getDefaultApplicationContext().getParent().getBeansOfType(this.getClass()).values().iterator()).hasNext()) {
                retVal = (IServletResource)iterator.next();
            }
        }
        return retVal;
    }

    public boolean isContainerCompatible() {
        return false;
    }

    protected void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

