/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.RegistrationRedirectException;
import org.jumpmind.symmetric.transport.handler.RegistrationResourceHandler;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;
import org.jumpmind.symmetric.web.AbstractTransportResourceServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationServlet
extends AbstractTransportResourceServlet<RegistrationResourceHandler>
implements IBuiltInExtensionPoint {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isContainerCompatible() {
        return true;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Node node = this.transform(req);
        try {
            OutputStream outputStream = this.createOutputStream(resp);
            if (!((RegistrationResourceHandler)this.getTransportResourceHandler()).registerNode(node, outputStream)) {
                this.log.warn("RegistrationNotAllowed", node);
                this.sendError(resp, 656, String.format("%s was not allowed to register.", node));
            }
        }
        catch (RegistrationRedirectException e) {
            resp.sendRedirect(HttpTransportManager.buildRegistrationUrl(e.getRedirectionUrl(), node));
        }
    }

    private Node transform(HttpServletRequest req) {
        Node node = new Node();
        node.setNodeGroupId(this.getParameter(req, "nodeGroupId"));
        node.setSymmetricVersion(this.getParameter(req, "symmetricVersion"));
        node.setExternalId(this.getParameter(req, "externalId"));
        String syncUrlString = this.getParameter(req, "syncURL");
        if (StringUtils.isNotBlank((String)syncUrlString)) {
            node.setSyncUrl(syncUrlString);
        }
        node.setSchemaVersion(this.getParameter(req, "schemaVersion"));
        node.setDatabaseType(this.getParameter(req, "databaseType"));
        node.setDatabaseVersion(this.getParameter(req, "databaseVersion"));
        return node;
    }
}

