/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.transport.IConcurrentConnectionManager;
import org.jumpmind.symmetric.web.AbstractFilter;

public class NodeConcurrencyFilter
extends AbstractFilter
implements IBuiltInExtensionPoint {
    private static final ILog log = LogFactory.getLog(NodeConcurrencyFilter.class);
    private IConcurrentConnectionManager concurrentConnectionManager;
    private IConfigurationService configurationService;
    private String reservationUriPattern;

    public boolean isContainerCompatible() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        block7: {
            HttpServletRequest httpRequest = (HttpServletRequest)req;
            String poolId = httpRequest.getRequestURI();
            String nodeId = StringUtils.trimToNull((String)req.getParameter("nodeId"));
            String method = httpRequest.getMethod();
            if (method.equals("HEAD") && this.matchesUriPattern(this.normalizeRequestUri(httpRequest), this.reservationUriPattern)) {
                resp.setContentLength(0);
                if (!this.concurrentConnectionManager.reserveConnection(nodeId, poolId, IConcurrentConnectionManager.ReservationType.SOFT)) {
                    this.sendError(resp, 503);
                } else {
                    this.buildSuspendIgnoreResponseHeaders(nodeId, resp);
                }
            } else {
                if (this.concurrentConnectionManager.reserveConnection(nodeId, poolId, IConcurrentConnectionManager.ReservationType.HARD)) {
                    try {
                        this.buildSuspendIgnoreResponseHeaders(nodeId, resp);
                        chain.doFilter(req, resp);
                        Object var9_8 = null;
                        this.concurrentConnectionManager.releaseConnection(nodeId, poolId);
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        this.concurrentConnectionManager.releaseConnection(nodeId, poolId);
                        throw throwable;
                    }
                    {
                        break block7;
                    }
                }
                this.sendError(resp, 503);
            }
        }
    }

    protected void buildSuspendIgnoreResponseHeaders(String nodeId, ServletResponse resp) {
        HttpServletResponse httpResponse = (HttpServletResponse)resp;
        ChannelMap suspendIgnoreChannels = this.configurationService.getSuspendIgnoreChannelLists(nodeId);
        httpResponse.setHeader("Suspended-Channels", suspendIgnoreChannels.getSuspendChannelsAsString());
        httpResponse.setHeader("Ignored-Channels", suspendIgnoreChannels.getIgnoreChannelsAsString());
    }

    protected ILog getLog() {
        return log;
    }

    public void setConcurrentConnectionManager(IConcurrentConnectionManager concurrentConnectionManager) {
        this.concurrentConnectionManager = concurrentConnectionManager;
    }

    public void setReservationUriPattern(String reservationUriPattern) {
        this.reservationUriPattern = reservationUriPattern;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public IConfigurationService getConfigurationService() {
        return this.configurationService;
    }
}

