/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.transport.InetAddressResourceHandler;
import org.jumpmind.symmetric.web.AbstractTransportFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetAddressFilter
extends AbstractTransportFilter<InetAddressResourceHandler>
implements IBuiltInExtensionPoint {
    public static final String INET_ADDRESS_FILTERS = "inetAddressFilters";
    public static final String INET_ADDRESS_ALLOW_MULICAST = "inetAddressAllowMultcast";
    private static final ILog log = LogFactory.getLog(InetAddressFilter.class);
    private InetAddressResourceHandler authorizer;

    @Override
    public void init(FilterConfig config) throws ServletException {
        String multicastAllowed;
        super.init(config);
        this.authorizer = (InetAddressResourceHandler)this.getTransportResourceHandler();
        String addressFilters = config.getInitParameter(INET_ADDRESS_FILTERS);
        if (addressFilters != null) {
            try {
                this.authorizer.setAddressFilters(addressFilters);
            }
            catch (UnknownHostException e) {
                throw new ServletException("Invalid fddress filter string: " + addressFilters, (Throwable)e);
            }
        }
        if (!StringUtils.isBlank((String)(multicastAllowed = config.getInitParameter(INET_ADDRESS_ALLOW_MULICAST)))) {
            this.authorizer.setMulicastAllowed(Boolean.parseBoolean(multicastAllowed.trim()));
        }
    }

    @Override
    public boolean isContainerCompatible() {
        return true;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        String sourceAddrString = httpRequest.getRemoteAddr();
        try {
            InetAddress sourceAddr = InetAddress.getByName(sourceAddrString);
            log.debug("AddressAuthorizing", sourceAddr.toString());
            if (this.authorizer.isAuthorized(sourceAddr)) {
                chain.doFilter(req, resp);
            } else {
                log.info("AddressDenied", sourceAddr.toString());
                this.sendError(resp, 403);
            }
        }
        catch (UnknownHostException uhe) {
            this.sendError(resp, 403);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.authorizer.clearFilters();
    }

    @Override
    protected ILog getLog() {
        return log;
    }
}

