/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.web.AbstractResourceServlet;

public class BandwidthSamplerServlet
extends AbstractResourceServlet
implements IBuiltInExtensionPoint {
    private static final long serialVersionUID = 1L;
    protected ILog log = LogFactory.getLog(this.getClass());
    IParameterService parameterService;
    protected long defaultTestSlowBandwidthDelay = 0L;

    protected ILog getLog() {
        return this.log;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long testSlowBandwidthDelay = this.parameterService != null ? this.parameterService.getLong("test.slow.bandwidth.delay") : this.defaultTestSlowBandwidthDelay;
        long sampleSize = 1000L;
        try {
            sampleSize = Long.parseLong(req.getParameter("sampleSize"));
        }
        catch (Exception ex) {
            this.log.warn("BandwidthSampleSizeParsingFailed", req.getParameter("sampleSize"));
        }
        ServletOutputStream os = resp.getOutputStream();
        int i = 0;
        while ((long)i < sampleSize) {
            os.write(1);
            if (testSlowBandwidthDelay > 0L) {
                AppUtils.sleep(testSlowBandwidthDelay);
            }
            ++i;
        }
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDefaultTestSlowBandwidthDelay(long defaultTestSlowBandwidthDelay) {
        this.defaultTestSlowBandwidthDelay = defaultTestSlowBandwidthDelay;
    }
}

