/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.transport.handler.AuthenticationResourceHandler;
import org.jumpmind.symmetric.web.AbstractTransportFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationFilter
extends AbstractTransportFilter<AuthenticationResourceHandler>
implements IBuiltInExtensionPoint {
    private static final ILog log = LogFactory.getLog(AuthenticationFilter.class);

    @Override
    public boolean isContainerCompatible() {
        return true;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String securityToken = req.getParameter("securityToken");
        String nodeId = req.getParameter("nodeId");
        if (StringUtils.isEmpty((String)securityToken) || StringUtils.isEmpty((String)nodeId)) {
            this.sendError(resp, 403);
            return;
        }
        AuthenticationResourceHandler.AuthenticationStatus status = ((AuthenticationResourceHandler)this.getTransportResourceHandler()).status(nodeId, securityToken);
        if (AuthenticationResourceHandler.AuthenticationStatus.FORBIDDEN.equals((Object)status)) {
            this.sendError(resp, 403);
        } else if (AuthenticationResourceHandler.AuthenticationStatus.REGISTRATION_REQUIRED.equals((Object)status)) {
            this.sendError(resp, 657);
        } else if (AuthenticationResourceHandler.AuthenticationStatus.SYNC_DISABLED.equals((Object)status)) {
            this.sendError(resp, 658);
        } else if (AuthenticationResourceHandler.AuthenticationStatus.ACCEPTED.equals((Object)status)) {
            chain.doFilter(req, resp);
        }
    }

    @Override
    protected ILog getLog() {
        return log;
    }
}

