/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.model.BatchInfo;
import org.jumpmind.symmetric.transport.AbstractTransportManager;
import org.jumpmind.symmetric.transport.handler.AckResourceHandler;
import org.jumpmind.symmetric.web.AbstractTransportResourceServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AckServlet
extends AbstractTransportResourceServlet<AckResourceHandler>
implements IBuiltInExtensionPoint {
    private static final BatchIdComparator BATCH_ID_COMPARATOR = new BatchIdComparator();
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isContainerCompatible() {
        return true;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AckResourceHandler ackService = (AckResourceHandler)this.getTransportResourceHandler();
        this.log.debug("DataAckReading", req.getParameterMap());
        List<BatchInfo> batches = AbstractTransportManager.readAcknowledgement(req.getParameterMap());
        Collections.sort(batches, BATCH_ID_COMPARATOR);
        ackService.ack(batches);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BatchIdComparator
    implements Comparator<BatchInfo> {
        private BatchIdComparator() {
        }

        @Override
        public int compare(BatchInfo batchInfo1, BatchInfo batchInfo2) {
            Long batchId1 = batchInfo1.getBatchId();
            Long batchId2 = batchInfo1.getBatchId();
            return batchId1.compareTo(batchId2);
        }
    }
}

