/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.web.ServletUtils;

public abstract class AbstractServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected final ILog log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected OutputStream createOutputStream(HttpServletResponse resp) throws IOException {
        return resp.getOutputStream();
    }

    protected ILog getLog() {
        return this.log;
    }

    protected InputStream createInputStream(HttpServletRequest req) throws IOException {
        boolean useCompression;
        Object is = null;
        String contentType = req.getHeader("Content-Type");
        boolean bl = useCompression = contentType != null && contentType.equalsIgnoreCase("gzip");
        if (this.getLog().isDebugEnabled()) {
            StringBuilder b = new StringBuilder();
            BufferedReader reader = null;
            if (useCompression) {
                this.getLog().debug("ServletCompressedStreamReceived");
                reader = new BufferedReader(new InputStreamReader(new GZIPInputStream((InputStream)req.getInputStream())));
            } else {
                reader = req.getReader();
            }
            String line = null;
            do {
                if ((line = reader.readLine()) == null) continue;
                b.append(line);
                b.append("\n");
            } while (line != null);
            this.getLog().debug("ServletReceived", b);
            is = new ByteArrayInputStream(b.toString().getBytes());
        } else {
            is = req.getInputStream();
            if (useCompression) {
                is = new GZIPInputStream((InputStream)is);
            }
        }
        return is;
    }

    protected boolean sendError(HttpServletResponse resp, int statusCode) throws IOException {
        return ServletUtils.sendError(resp, statusCode);
    }

    protected boolean sendError(HttpServletResponse resp, int statusCode, String message) throws IOException {
        return ServletUtils.sendError(resp, statusCode, message);
    }

    protected String getParameter(HttpServletRequest request, String name) {
        return StringUtils.trimToNull((String)request.getParameter(name));
    }

    protected String getParameter(HttpServletRequest request, String name, String defaultValue) {
        return StringUtils.defaultIfEmpty((String)StringUtils.trimToNull((String)request.getParameter(name)), (String)defaultValue);
    }

    protected long getParameterAsNumber(HttpServletRequest request, String name) {
        return NumberUtils.toLong((String)StringUtils.trimToNull((String)request.getParameter(name)));
    }
}

