/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.jumpmind.symmetric.transport.ITransportResource;
import org.jumpmind.symmetric.web.AbstractServlet;
import org.jumpmind.symmetric.web.IServletExtension;
import org.jumpmind.symmetric.web.IServletResource;
import org.jumpmind.symmetric.web.ServletResourceTemplate;
import org.jumpmind.symmetric.web.ServletUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;

public abstract class AbstractResourceServlet
extends AbstractServlet
implements IServletResource,
IServletExtension {
    private static final long serialVersionUID = 1L;
    private ServletResourceTemplate servletResourceTemplate = new ServletResourceTemplate();
    private int initOrder;

    public boolean isContainerCompatible() {
        return false;
    }

    public int getInitOrder() {
        return this.initOrder;
    }

    public void setInitOrder(int initOrder) {
        this.initOrder = initOrder;
    }

    public Servlet getServlet() {
        return this;
    }

    public boolean isAutoRegister() {
        return true;
    }

    public void destroy() {
        this.servletResourceTemplate.destroy();
    }

    public boolean isDisabled() {
        return this.servletResourceTemplate.isDisabled();
    }

    public String[] getUriPatterns() {
        return this.servletResourceTemplate.getUriPatterns();
    }

    public boolean matches(ServletRequest request) {
        return this.servletResourceTemplate.matches(request);
    }

    public void setDisabled(boolean disabled) {
        this.servletResourceTemplate.setDisabled(disabled);
    }

    public void setEnabled(boolean enabled) {
        this.servletResourceTemplate.setDisabled(!enabled);
    }

    public void setUriPattern(String uriPattern) {
        this.servletResourceTemplate.setUriPattern(uriPattern);
    }

    public void setUriPatterns(String[] uriPatterns) {
        this.servletResourceTemplate.setUriPatterns(uriPatterns);
    }

    public String toString() {
        return this.servletResourceTemplate.toString();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        IServletResource springBean;
        super.init(servletConfig);
        this.servletResourceTemplate.init(this.getServletContext());
        if (this.isContainerCompatible() && !this.isSpringManaged() && this != (springBean = this.getSpringBean())) {
            this.getLog().info("ServletInitializing", springBean.getClass().getSimpleName());
            BeanUtils.copyProperties((Object)springBean, (Object)this, IServletResource.class);
            BeanUtils.copyProperties((Object)springBean, (Object)this, ITransportResource.class);
            BeanUtils.copyProperties((Object)springBean, (Object)this, this.getClass());
        }
    }

    protected boolean isSpringManaged() {
        ApplicationContext ctx = ServletUtils.getApplicationContext(this.getServletContext());
        boolean managed = ctx.getBeansOfType(this.getClass()).values().contains(this);
        if (!managed && ctx.getParent() != null) {
            managed = ctx.getParent().getBeansOfType(this.getClass()).values().contains(this);
        }
        return managed;
    }

    protected IServletResource getSpringBean() {
        IServletResource retVal = this;
        if (!this.isSpringManaged()) {
            ApplicationContext ctx = ServletUtils.getApplicationContext(this.getServletContext());
            Iterator iterator = ctx.getBeansOfType(this.getClass()).values().iterator();
            if (iterator.hasNext()) {
                retVal = (IServletResource)iterator.next();
            }
            if (retVal == null && ctx.getParent() != null && (iterator = ctx.getParent().getBeansOfType(this.getClass()).values().iterator()).hasNext()) {
                retVal = (IServletResource)iterator.next();
            }
        }
        return retVal;
    }

    public void init(ServletContext servletContext) {
        this.servletResourceTemplate.init(servletContext);
    }
}

