/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.util.Random;
import org.jumpmind.symmetric.service.IParameterService;

public class RandomTimeSlot {
    int maxValue = -1;
    Random random;

    public RandomTimeSlot() {
        this.random = new Random();
    }

    public RandomTimeSlot(String externalId, int maxValue) {
        this.maxValue = maxValue;
        this.random = new Random(this.fromExternalId(externalId));
    }

    private long fromExternalId(String externalId) {
        if (externalId != null) {
            return Math.abs(externalId.hashCode());
        }
        return Integer.MAX_VALUE;
    }

    public void setParameterService(IParameterService s) {
        long seed = this.fromExternalId(s.getExternalId());
        this.random = new Random(seed);
        if (this.maxValue < 0) {
            this.maxValue = s.getInt("job.random.max.start.time.ms");
        }
    }

    public int getRandomValueSeededByDomainId() {
        int nextValue = this.random.nextInt(this.maxValue);
        return nextValue == 0 ? 1 : nextValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }
}

