/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;

public class CsvUtils {
    static final ILog log = LogFactory.getLog(CsvUtils.class);
    public static final String DELIMITER = ", ";

    public static CsvReader getCsvReader(Reader reader) {
        CsvReader csvReader = new CsvReader(reader);
        csvReader.setEscapeMode(2);
        csvReader.setSafetySwitch(false);
        return csvReader;
    }

    public static String[] tokenizeCsvData(String csvData) {
        String[] tokens = null;
        if (csvData != null) {
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(csvData.getBytes()));
            CsvReader csvReader = new CsvReader(reader);
            csvReader.setEscapeMode(2);
            try {
                if (csvReader.readRecord()) {
                    tokens = csvReader.getValues();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return tokens;
    }

    public static String escapeCsvData(String data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CsvWriter writer = new CsvWriter(new OutputStreamWriter(out), ',');
        writer.setEscapeMode(2);
        try {
            writer.write(data);
            writer.close();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public static void write(BufferedWriter writer, String ... data) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (String string : data) {
            buffer.append(string);
        }
        writer.write(buffer.toString());
        log.debug("BufferWriting", buffer);
    }

    public static void writeSql(String sql, BufferedWriter writer) throws IOException {
        CsvUtils.write(writer, "sql", DELIMITER, sql);
        writer.newLine();
    }

    public static void writeBsh(String script, BufferedWriter writer) throws IOException {
        CsvUtils.write(writer, "bsh", DELIMITER, script);
        writer.newLine();
    }
}

