/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricWebServer;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppUtils {
    private static String UNKNOWN = "unknown";
    private static ILog log = LogFactory.getLog(AppUtils.class);
    private static final String SYM_TEMP_SUFFIX = ".sym.tmp";
    private static String serverId;
    private static FastDateFormat timezoneFormatter;

    public static String getServerId() {
        if (StringUtils.isBlank((String)serverId) && StringUtils.isBlank((String)(serverId = System.getProperty("runtime.symmetric.cluster.server.id", null))) && StringUtils.isBlank((String)(serverId = System.getProperty("bind.address", null)))) {
            try {
                serverId = AppUtils.getHostName();
            }
            catch (Exception ex) {
                serverId = "unknown";
            }
        }
        return serverId;
    }

    public static String getHostName() {
        String hostName = System.getProperty("host.name", UNKNOWN);
        if (UNKNOWN.equals(hostName)) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                log.warn(ex);
            }
        }
        return hostName;
    }

    public static String getIpAddress() {
        String ipAddress = System.getProperty("ip.address", UNKNOWN);
        if (UNKNOWN.equals(ipAddress)) {
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception ex) {
                log.warn(ex);
            }
        }
        return ipAddress;
    }

    public static String replace(String prop, String replaceWith, String sourceString) {
        return StringUtils.replace((String)sourceString, (String)("$(" + prop + ")"), (String)replaceWith);
    }

    public static String getTimezoneOffset() {
        String tz = timezoneFormatter.format(new Date());
        if (tz != null && tz.length() == 5) {
            return tz.substring(0, 3) + ":" + tz.substring(3, 5);
        }
        return null;
    }

    public static <T> T find(String name, ISymmetricEngine engine) {
        return (T)engine.getApplicationContext().getBean(name);
    }

    public static <T> T find(String name, SymmetricWebServer server) {
        return (T)server.getEngine().getApplicationContext().getBean(name);
    }

    public static File createTempFile(String token) throws IOException {
        return File.createTempFile(token + ".", SYM_TEMP_SUFFIX);
    }

    public static void cleanupTempFiles() {
        try {
            File tmp = File.createTempFile("temp.", SYM_TEMP_SUFFIX);
            Iterator it = FileUtils.iterateFiles((File)tmp.getParentFile(), (String[])new String[]{SYM_TEMP_SUFFIX}, (boolean)true);
            int deletedCount = 0;
            while (it.hasNext()) {
                FileUtils.forceDelete((File)((File)it.next()));
                ++deletedCount;
            }
            if (deletedCount > 1) {
                log.warn("CleanStrandedTempFiles");
            }
        }
        catch (Exception ex) {
            log.error(ex);
        }
    }

    public static Date getLocalDateForOffset(String timezoneOffset) {
        long currentTime = System.currentTimeMillis();
        int myOffset = TimeZone.getDefault().getOffset(currentTime);
        int theirOffset = TimeZone.getTimeZone("GMT" + timezoneOffset).getOffset(currentTime);
        return new Date(currentTime - (long)myOffset + (long)theirOffset);
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.warn("Message", e.getMessage());
        }
    }

    public static void resetDataSource(DataSource ds) {
        if (ds instanceof BasicDataSource) {
            BasicDataSource bds = (BasicDataSource)ds;
            try {
                bds.close();
            }
            catch (Exception ex) {
                log.warn(ex);
            }
        }
    }

    static {
        timezoneFormatter = FastDateFormat.getInstance((String)"Z");
    }
}

