/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.upgrade;

import java.util.List;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.upgrade.AbstractSqlUpgradeTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlUpgradeTask
extends AbstractSqlUpgradeTask {
    private static final ILog log = LogFactory.getLog(SqlUpgradeTask.class);
    protected IDbDialect dbDialect;
    protected String dialectName;
    protected List<String> sqlList;
    protected boolean ignoreFailure;

    @Override
    public void upgrade(int[] fromVersion) {
        for (String sql : this.sqlList) {
            log.warn("SqlUpgrade", sql);
            this.jdbcTemplate.update(sql);
        }
    }

    @Override
    public void upgrade(String nodeId, IParameterService parameterService, int[] fromVersion) {
        if (this.dialectName == null || this.dbDialect != null && this.dbDialect.getName().equalsIgnoreCase(this.dialectName)) {
            for (String sql : this.sqlList) {
                sql = this.prepareSql(nodeId, parameterService, sql);
                log.warn("SqlUpgrade", sql);
                if (this.ignoreFailure) {
                    try {
                        this.jdbcTemplate.update(sql);
                    }
                    catch (Exception e) {
                        log.warn("SqlUpgradeIgnoring", e.getMessage());
                    }
                    continue;
                }
                this.jdbcTemplate.update(sql);
            }
        }
    }

    public void setSqlList(List<String> sqlList) {
        this.sqlList = sqlList;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    public void setDialectName(String dialectName) {
        this.dialectName = dialectName;
    }
}

