/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.upgrade;

import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.upgrade.IUpgradeTask;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractSqlUpgradeTask
implements IUpgradeTask {
    protected JdbcTemplate jdbcTemplate;
    protected boolean isUpgradeRegistrationServer = true;
    protected boolean isUpgradeNonRegistrationServer = true;
    protected boolean useReplacement = true;

    public void upgrade(int[] fromVersion) {
    }

    protected String prepareSql(String nodeId, IParameterService parameterService, String sql) {
        if (this.useReplacement) {
            sql = this.replace("groupId", parameterService.getNodeGroupId(), sql);
            sql = this.replace("externalId", parameterService.getExternalId(), sql);
            sql = this.replace("nodeId", nodeId, sql);
        }
        return sql;
    }

    protected String replace(String prop, String replaceWith, String sourceString) {
        return StringUtils.replace((String)sourceString, (String)("$(" + prop + ")"), (String)replaceWith);
    }

    public void setJdbcTemplate(JdbcTemplate jdbc) {
        this.jdbcTemplate = jdbc;
    }

    public boolean isUpgradeNonRegistrationServer() {
        return this.isUpgradeNonRegistrationServer;
    }

    public boolean getUpgradeNonRegistrationServer() {
        return this.isUpgradeNonRegistrationServer;
    }

    public void setUpgradeNonRegistrationServer(boolean isUpgradeNonRegistrationServer) {
        this.isUpgradeNonRegistrationServer = isUpgradeNonRegistrationServer;
    }

    public boolean isUpgradeRegistrationServer() {
        return this.isUpgradeRegistrationServer;
    }

    public boolean getUpgradeRegistrationServer() {
        return this.isUpgradeRegistrationServer;
    }

    public void setUpgradeRegistrationServer(boolean isUpgradeRegistrationServer) {
        this.isUpgradeRegistrationServer = isUpgradeRegistrationServer;
    }

    public boolean getUseReplacement() {
        return this.useReplacement;
    }

    public void setUseReplacement(boolean useReplacement) {
        this.useReplacement = useReplacement;
    }
}

