/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.AbstractTransportManager;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.TransportUtils;
import org.jumpmind.symmetric.transport.http.HttpIncomingTransport;
import org.jumpmind.symmetric.transport.http.HttpOutgoingTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTransportManager
extends AbstractTransportManager
implements ITransportManager {
    protected static final Log logger = LogFactory.getLog(HttpTransportManager.class);
    private IParameterService parameterService;

    public HttpTransportManager() {
    }

    public HttpTransportManager(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public int sendAcknowledgement(Node remote, List<IncomingBatch> list, Node local, String securityToken, String registrationUrl) throws IOException {
        if (list != null && list.size() > 0) {
            String data = this.getAcknowledgementData(local.getNodeId(), list);
            return this.sendMessage("ack", remote, local, data, securityToken, registrationUrl);
        }
        return 200;
    }

    @Override
    public void writeAcknowledgement(OutputStream out, List<IncomingBatch> list, Node local, String securityToken) throws IOException {
        this.writeMessage(out, this.getAcknowledgementData(local.getNodeId(), list));
    }

    protected int sendMessage(String action, Node remote, Node local, String data, String securityToken, String registrationUrl) throws IOException {
        HttpURLConnection conn = this.sendMessage(new URL(this.buildURL(action, remote, local, securityToken, registrationUrl)), data);
        return conn.getResponseCode();
    }

    protected HttpURLConnection sendMessage(URL url, String data) throws IOException {
        HttpURLConnection conn = HttpTransportManager.openConnection(url, this.getBasicAuthUsername(), this.getBasicAuthPassword());
        conn.setRequestMethod("POST");
        conn.setAllowUserInteraction(false);
        conn.setDoOutput(true);
        conn.setConnectTimeout(this.getHttpTimeOutInMs());
        conn.setReadTimeout(this.getHttpTimeOutInMs());
        conn.setRequestProperty("Content-Length", Integer.toString(data.length()));
        this.writeMessage(conn.getOutputStream(), data);
        return conn;
    }

    public static HttpURLConnection openConnection(URL url, String username, String password) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        HttpTransportManager.setBasicAuthIfNeeded(conn, username, password);
        return conn;
    }

    public static void setBasicAuthIfNeeded(HttpURLConnection conn, String username, String password) {
        if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
            String userpassword = username + ":" + password;
            String encodedAuthorization = new String(Base64.encodeBase64((byte[])userpassword.getBytes()));
            conn.setRequestProperty("Authorization", "Basic " + encodedAuthorization);
        }
    }

    public int getOutputStreamSize() {
        return this.parameterService.getInt("http.push.stream.output.size");
    }

    public boolean isOutputStreamEnabled() {
        return this.parameterService.is("http.push.stream.output.enabled");
    }

    public int getHttpTimeOutInMs() {
        return this.parameterService.getInt("http.timeout.ms");
    }

    public boolean isUseCompression() {
        return this.parameterService.is("http.compression");
    }

    public int getCompressionLevel() {
        return this.parameterService.getInt("compression.level");
    }

    public int getCompressionStrategy() {
        return this.parameterService.getInt("compression.strategy");
    }

    public String getBasicAuthUsername() {
        return this.parameterService.getString("http.basic.auth.username");
    }

    public String getBasicAuthPassword() {
        return this.parameterService.getString("http.basic.auth.password");
    }

    public void writeMessage(OutputStream out, String data) throws IOException {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(out, "UTF-8"), true);
        pw.println(data);
        pw.close();
    }

    @Override
    public IIncomingTransport getPullTransport(Node remote, Node local, String securityToken, Map<String, String> requestProperties, String registrationUrl) throws IOException {
        HttpURLConnection conn = this.createGetConnectionFor(new URL(this.buildURL("pull", remote, local, securityToken, registrationUrl)));
        if (requestProperties != null) {
            for (String key : requestProperties.keySet()) {
                conn.addRequestProperty(key, requestProperties.get(key));
            }
        }
        return new HttpIncomingTransport(conn, this.parameterService);
    }

    @Override
    public IOutgoingWithResponseTransport getPushTransport(Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        URL url = new URL(this.buildURL("push", remote, local, securityToken, registrationUrl));
        return new HttpOutgoingTransport(url, this.getHttpTimeOutInMs(), this.isUseCompression(), this.getCompressionStrategy(), this.getCompressionLevel(), this.getBasicAuthUsername(), this.getBasicAuthPassword(), this.isOutputStreamEnabled(), this.getOutputStreamSize());
    }

    @Override
    public IIncomingTransport getRegisterTransport(Node node, String registrationUrl) throws IOException {
        return new HttpIncomingTransport(this.createGetConnectionFor(new URL(HttpTransportManager.buildRegistrationUrl(registrationUrl, node))), this.parameterService);
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public static String buildRegistrationUrl(String baseUrl, Node node) throws IOException {
        StringBuilder builder = new StringBuilder(baseUrl);
        builder.append("/registration?");
        HttpTransportManager.append(builder, "nodeGroupId", node.getNodeGroupId());
        HttpTransportManager.append(builder, "externalId", node.getExternalId());
        HttpTransportManager.append(builder, "syncURL", node.getSyncUrl());
        HttpTransportManager.append(builder, "schemaVersion", node.getSchemaVersion());
        HttpTransportManager.append(builder, "databaseType", node.getDatabaseType());
        HttpTransportManager.append(builder, "databaseVersion", node.getDatabaseVersion());
        HttpTransportManager.append(builder, "symmetricVersion", node.getSymmetricVersion());
        return builder.toString();
    }

    protected HttpURLConnection createGetConnectionFor(URL url) throws IOException {
        HttpURLConnection conn = HttpTransportManager.openConnection(url, this.getBasicAuthUsername(), this.getBasicAuthPassword());
        conn.setRequestProperty("accept-encoding", "gzip");
        conn.setConnectTimeout(this.getHttpTimeOutInMs());
        conn.setReadTimeout(this.getHttpTimeOutInMs());
        conn.setRequestMethod("GET");
        return conn;
    }

    protected static BufferedReader getReaderFrom(HttpURLConnection connection) throws IOException {
        String type = connection.getContentEncoding();
        InputStream in = connection.getInputStream();
        if (!StringUtils.isBlank((String)type) && type.equals("gzip")) {
            in = new GZIPInputStream(in);
        }
        return TransportUtils.toReader(in);
    }

    protected String buildURL(String action, Node remote, Node local, String securityToken, String registrationUrl) throws IOException {
        return this.addSecurityToken(this.resolveURL(remote.getSyncUrl(), registrationUrl) + "/" + action, "&", local.getNodeId(), securityToken);
    }

    protected String addSecurityToken(String base, String connector, String nodeId, String securityToken) {
        StringBuilder sb = new StringBuilder(this.addNodeId(base, nodeId, "?"));
        sb.append(connector);
        sb.append("securityToken");
        sb.append("=");
        sb.append(securityToken);
        return sb.toString();
    }

    protected String addNodeId(String base, String nodeId, String connector) {
        StringBuilder sb = new StringBuilder(base);
        sb.append(connector);
        sb.append("nodeId");
        sb.append("=");
        sb.append(nodeId);
        return sb.toString();
    }
}

