/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.handler;

import java.io.IOException;
import java.io.OutputStream;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.transport.handler.AbstractTransportResourceHandler;

public class PullResourceHandler
extends AbstractTransportResourceHandler {
    private INodeService nodeService;
    private IConfigurationService configurationService;
    private IDataService dataService;
    private IDataExtractorService dataExtractorService;
    private IRegistrationService registrationService;

    public void pull(String nodeId, OutputStream outputStream, ChannelMap map) throws IOException {
        INodeService nodeService = this.getNodeService();
        NodeSecurity nodeSecurity = nodeService.findNodeSecurity(nodeId);
        ChannelMap remoteSuspendIgnoreChannelsList = this.configurationService.getSuspendIgnoreChannelLists(nodeId);
        map.addSuspendChannels(remoteSuspendIgnoreChannelsList.getSuspendChannels());
        map.addIgnoreChannels(remoteSuspendIgnoreChannelsList.getIgnoreChannels());
        if (nodeSecurity != null) {
            if (nodeSecurity.isRegistrationEnabled()) {
                this.registrationService.registerNode(nodeService.findNode(nodeId), outputStream, false);
            } else {
                if (nodeSecurity.isInitialLoadEnabled()) {
                    this.dataService.insertReloadEvent(nodeService.findNode(nodeId));
                }
                IOutgoingTransport outgoingTransport = this.createOutgoingTransport(outputStream, map);
                this.dataExtractorService.extract(nodeService.findNode(nodeId), outgoingTransport);
                outgoingTransport.close();
            }
        } else {
            this.log.warn("NodeMissing", nodeId);
        }
    }

    private INodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public IConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setDataService(IDataService dataService) {
        this.dataService = dataService;
    }

    public void setDataExtractorService(IDataExtractorService dataExtractorService) {
        this.dataExtractorService = dataExtractorService;
    }
}

