/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.handler;

import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.transport.handler.AbstractTransportResourceHandler;

public class AuthenticationResourceHandler
extends AbstractTransportResourceHandler {
    private INodeService nodeService;

    public AuthenticationStatus status(String nodeId, String securityToken) {
        AuthenticationStatus retVal = AuthenticationStatus.ACCEPTED;
        if (this.nodeService.findNode(nodeId) == null) {
            retVal = AuthenticationStatus.REGISTRATION_REQUIRED;
        } else if (!this.syncEnabled(nodeId)) {
            retVal = AuthenticationStatus.SYNC_DISABLED;
        } else if (!this.nodeService.isNodeAuthorized(nodeId, securityToken)) {
            retVal = AuthenticationStatus.FORBIDDEN;
        }
        return retVal;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected boolean syncEnabled(String nodeId) {
        boolean syncEnabled = false;
        Node node = this.nodeService.findNode(nodeId);
        if (node != null) {
            syncEnabled = node.isSyncEnabled();
        }
        return syncEnabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthenticationStatus {
        SYNC_DISABLED,
        REGISTRATION_REQUIRED,
        FORBIDDEN,
        ACCEPTED;

    }
}

