/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.handler;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.OutgoingBatches;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.handler.AbstractTransportResourceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertResourceHandler
extends AbstractTransportResourceHandler {
    private static final int MAX_ERRORS = 1000;
    private static final FastDateFormat formatter = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private IIncomingBatchService incomingBatchService;
    private IOutgoingBatchService outgoingBatchService;
    private IParameterService parameterService;
    private INodeService nodeService;

    public void write(CharSequence feedURL, Writer outputWriter) throws IOException {
        try {
            String msg;
            int sqlCode;
            StringBuilder value;
            String title;
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType("rss_2.0");
            feed.setTitle("SymmetricDS Alerts for " + this.parameterService.getSyncUrl());
            feed.setDescription("Problems synchronizing data");
            feed.setLink(((Object)feedURL).toString());
            ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
            for (IncomingBatch incomingBatch : this.findIncomingBatchErrors()) {
                title = "Incoming Batch " + incomingBatch.getNodeBatchId();
                value = new StringBuilder("Node ");
                value.append(incomingBatch.getNodeId());
                value.append(" incoming batch ");
                value.append(incomingBatch.getBatchId());
                value.append(" is in error at ");
                value.append(this.formatDate(incomingBatch.getCreateTime()));
                value.append(".  ");
                sqlCode = incomingBatch.getSqlCode();
                msg = incomingBatch.getSqlMessage();
                if (sqlCode > 0 || !StringUtils.isBlank((String)msg)) {
                    value.append("The sql error code is ");
                    value.append(sqlCode);
                    value.append(" and the error message is: ");
                    value.append(msg);
                }
                entries.add(this.createEntry(title, value.toString(), incomingBatch.getCreateTime(), this.nodeService.findNode(incomingBatch.getNodeId()).getSyncUrl() + "/batch/" + incomingBatch.getBatchId()));
            }
            for (OutgoingBatch outgoingBatch : this.findOutgoingBatchErrors().getBatches()) {
                title = "Outgoing Batch " + outgoingBatch.getNodeBatchId();
                value = new StringBuilder("Node ");
                value.append(outgoingBatch.getNodeId());
                value.append(" outgoing batch ");
                value.append(outgoingBatch.getBatchId());
                value.append(" is in error at ");
                value.append(this.formatDate(outgoingBatch.getCreateTime()));
                value.append(".  ");
                value.append("The batch has been attempted ");
                value.append(outgoingBatch.getSentCount());
                value.append(" times.  ");
                sqlCode = outgoingBatch.getSqlCode();
                msg = outgoingBatch.getSqlMessage();
                if (sqlCode > 0 || !StringUtils.isBlank((String)msg)) {
                    value.append("The sql error code is ");
                    value.append(sqlCode);
                    value.append(" and the error message is: ");
                    value.append(msg);
                }
                entries.add(this.createEntry(title, value.toString(), outgoingBatch.getCreateTime(), "batch/" + outgoingBatch.getBatchId()));
            }
            Collections.sort(entries, new SyndEntryOrderer());
            feed.setEntries(entries);
            SyndFeedOutput out = new SyndFeedOutput();
            out.output((SyndFeed)feed, outputWriter);
        }
        catch (FeedException e) {
            this.log.warn(e);
            throw new IOException(e.getMessage());
        }
    }

    private SyndEntry createEntry(String title, String value, Date publishedDate, String sourceLink) {
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setTitle(title);
        if (sourceLink != null) {
            entry.setLink(sourceLink);
        }
        entry.setPublishedDate(publishedDate);
        SyndContentImpl content = new SyndContentImpl();
        content.setType("text/html");
        content.setValue(value);
        entry.setDescription((SyndContent)content);
        return entry;
    }

    private String formatDate(Date date) {
        return formatter.format(date);
    }

    private List<IncomingBatch> findIncomingBatchErrors() {
        return this.getIncomingBatchService().findIncomingBatchErrors(1000);
    }

    private OutgoingBatches findOutgoingBatchErrors() {
        return this.getOutgoingBatchService().getOutgoingBatchErrors(1000);
    }

    private IIncomingBatchService getIncomingBatchService() {
        return this.incomingBatchService;
    }

    public void setIncomingBatchService(IIncomingBatchService incomingBatchService) {
        this.incomingBatchService = incomingBatchService;
    }

    private IOutgoingBatchService getOutgoingBatchService() {
        return this.outgoingBatchService;
    }

    public void setOutgoingBatchService(IOutgoingBatchService outgoingBatchService) {
        this.outgoingBatchService = outgoingBatchService;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SyndEntryOrderer
    implements Comparator<SyndEntry> {
        SyndEntryOrderer() {
        }

        @Override
        public int compare(SyndEntry o1, SyndEntry o2) {
            return o1.getPublishedDate().compareTo(o2.getPublishedDate());
        }
    }
}

