/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.file;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.io.ThresholdFileWriter;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.transport.IOutgoingTransport;

public class FileOutgoingTransport
implements IOutgoingTransport {
    BufferedWriter out;
    ThresholdFileWriter fileWriter;

    public FileOutgoingTransport(long threshold, String tempFileCategory) throws IOException {
        this.fileWriter = new ThresholdFileWriter(threshold, tempFileCategory);
    }

    public BufferedWriter open() throws IOException {
        this.out = new BufferedWriter(this.fileWriter);
        return this.out;
    }

    public boolean isOpen() {
        return this.out != null;
    }

    public void close() throws IOException {
        IOUtils.closeQuietly((Writer)this.out);
        this.out = null;
    }

    public Reader getReader() throws IOException {
        return this.fileWriter.getReader();
    }

    public void delete() {
        if (this.fileWriter != null) {
            this.fileWriter.delete();
        }
    }

    public ChannelMap getSuspendIgnoreChannelLists(IConfigurationService configurationService) throws IOException {
        return new ChannelMap();
    }
}

