/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.security.inet.IInetAddressAuthorizer;
import org.jumpmind.symmetric.security.inet.IInetAddressAuthorizerCompiler;
import org.jumpmind.symmetric.security.inet.IRawInetAddressAuthorizer;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.handler.AbstractTransportResourceHandler;

public class InetAddressResourceHandler
extends AbstractTransportResourceHandler
implements IInetAddressAuthorizer {
    private static final ILog log = LogFactory.getLog(InetAddressResourceHandler.class);
    public static final String FILTER_DELIMITER = ",";
    private List<IRawInetAddressAuthorizer> filters;
    private IInetAddressAuthorizerCompiler addressCompiler;
    private IParameterService parameterService;
    private boolean isMulicastAllowed;

    public void clearFilters() {
        this.filters = null;
    }

    public synchronized void setAddressFilters(String filterString) throws UnknownHostException {
        String[] filtersTokens = null;
        if (StringUtils.isBlank((String)filterString)) {
            this.filters = Collections.emptyList();
            log.warn("AddressFiltersMissing");
        } else {
            filtersTokens = filterString.split(FILTER_DELIMITER);
            this.filters = this.addressCompiler.compile(filtersTokens);
        }
    }

    public boolean isAuthorized(String sourceAddress) {
        try {
            InetAddress inetAddress = InetAddress.getByName(sourceAddress);
            return this.isAuthorized(inetAddress);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(uhe.getMessage(), uhe);
        }
    }

    public boolean isAuthorized(InetAddress checkAddress) {
        boolean isMulticast;
        if (this.filters == null) {
            String filterString = this.parameterService.getString("ip.filters");
            log.debug("AddressFilterStringExtracted", filterString);
            try {
                this.setAddressFilters(filterString);
            }
            catch (UnknownHostException e) {
                throw new SymmetricException("AddressFilterStringExtractingFailed");
            }
        }
        if ((isMulticast = this.isMulticastAddress(checkAddress)) && !this.isMulicastAllowed) {
            log.info("AddressMultiCastDisallowed", checkAddress.toString());
            return false;
        }
        byte[] addressBytes = checkAddress.getAddress();
        for (IRawInetAddressAuthorizer filter : this.filters) {
            if (!filter.isAuthorized(addressBytes)) continue;
            return true;
        }
        log.info("AddressDenied", checkAddress.toString());
        return false;
    }

    public boolean isMulicastAllowed() {
        return this.isMulicastAllowed;
    }

    public void setMulicastAllowed(boolean isMulicastAllowed) {
        this.isMulicastAllowed = isMulicastAllowed;
    }

    public void setAddressCompiler(IInetAddressAuthorizerCompiler addressCompiler) {
        this.addressCompiler = addressCompiler;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    private boolean isMulticastAddress(InetAddress checkAddress) {
        if (checkAddress instanceof Inet4Address) {
            Inet4Address ip4Addr = (Inet4Address)checkAddress;
            return ip4Addr.isMulticastAddress();
        }
        if (checkAddress instanceof Inet6Address) {
            Inet6Address ip6Addr = (Inet6Address)checkAddress;
            return ip6Addr.isMulticastAddress();
        }
        return checkAddress.isMulticastAddress();
    }
}

