/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.model.BatchInfo;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.transport.ISyncUrlExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransportManager {
    protected ILog log = LogFactory.getLog(this.getClass());
    protected Map<String, ISyncUrlExtension> extensionSyncUrlHandlers = new HashMap<String, ISyncUrlExtension>();

    public void addExtensionSyncUrlHandler(String name, ISyncUrlExtension handler) {
        if (this.extensionSyncUrlHandlers == null) {
            this.extensionSyncUrlHandlers = new HashMap<String, ISyncUrlExtension>();
        }
        if (this.extensionSyncUrlHandlers.containsKey(name)) {
            this.log.warn("TransportSyncURLOverriding", name);
        }
        this.extensionSyncUrlHandlers.put(name, handler);
    }

    public String resolveURL(String syncUrl, String registrationUrl) {
        if (StringUtils.isBlank((String)syncUrl) || syncUrl.startsWith("nop")) {
            this.log.debug("TransportSyncURLBlank");
            return registrationUrl;
        }
        if (syncUrl.startsWith("ext")) {
            try {
                URI uri = new URI(syncUrl);
                ISyncUrlExtension handler = this.extensionSyncUrlHandlers.get(uri.getHost());
                if (handler == null) {
                    this.log.error("TransportSyncURLMissing", uri.getHost(), syncUrl);
                    return syncUrl;
                }
                return handler.resolveUrl(uri);
            }
            catch (URISyntaxException e) {
                this.log.error(e);
                return syncUrl;
            }
        }
        return syncUrl;
    }

    protected String getAcknowledgementData(String nodeId, List<IncomingBatch> list) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (IncomingBatch batch : list) {
            Object value = null;
            value = batch.getStatus() == IncomingBatch.Status.OK || batch.getStatus() == IncomingBatch.Status.SK ? "ok" : Long.valueOf(batch.getFailedRowNumber());
            AbstractTransportManager.append(builder, "batch-" + batch.getBatchId(), value);
        }
        builder.append("\n");
        for (IncomingBatch batch : list) {
            long batchId = batch.getBatchId();
            AbstractTransportManager.append(builder, "nodeId-" + batchId, nodeId);
            AbstractTransportManager.append(builder, "network-" + batchId, batch.getNetworkMillis());
            AbstractTransportManager.append(builder, "filter-" + batchId, batch.getFilterMillis());
            AbstractTransportManager.append(builder, "database-" + batchId, batch.getDatabaseMillis());
            AbstractTransportManager.append(builder, "byteCount-" + batchId, batch.getByteCount());
            if (batch.getStatus() != IncomingBatch.Status.ER) continue;
            AbstractTransportManager.append(builder, "sqlState-" + batchId, batch.getSqlState());
            AbstractTransportManager.append(builder, "sqlCode-" + batchId, batch.getSqlCode());
            AbstractTransportManager.append(builder, "sqlMessage-" + batchId, batch.getSqlMessage());
        }
        return builder.toString();
    }

    protected static void append(StringBuilder builder, String name, Object value) throws IOException {
        int len = builder.length();
        if (len > 0 && builder.charAt(len - 1) != '?') {
            builder.append("&");
        }
        if (value == null) {
            value = "";
        }
        builder.append(name).append("=").append(URLEncoder.encode(value.toString(), "UTF-8"));
    }

    public List<BatchInfo> readAcknowledgement(String parameterString1, String parameterString2) throws IOException {
        return this.readAcknowledgement(parameterString1 + "&" + parameterString2);
    }

    public List<BatchInfo> readAcknowledgement(String parameterString) throws IOException {
        Map<String, Object> parameters = AbstractTransportManager.getParametersFromQueryUrl(parameterString.replace("\n", ""));
        return AbstractTransportManager.readAcknowledgement(parameters);
    }

    public static List<BatchInfo> readAcknowledgement(Map<String, Object> parameters) {
        ArrayList<BatchInfo> batches = new ArrayList<BatchInfo>();
        for (String parameterName : parameters.keySet()) {
            if (!parameterName.startsWith("batch-")) continue;
            long batchId = NumberUtils.toLong((String)parameterName.substring("batch-".length()));
            BatchInfo batchInfo = AbstractTransportManager.getBatchInfo(parameters, batchId);
            batches.add(batchInfo);
        }
        return batches;
    }

    private static BatchInfo getBatchInfo(Map<String, Object> parameters, long batchId) {
        BatchInfo batchInfo = new BatchInfo(batchId);
        batchInfo.setNodeId(AbstractTransportManager.getParam(parameters, "nodeId-" + batchId));
        batchInfo.setNetworkMillis(AbstractTransportManager.getParamAsNum(parameters, "network-" + batchId));
        batchInfo.setFilterMillis(AbstractTransportManager.getParamAsNum(parameters, "filter-" + batchId));
        batchInfo.setDatabaseMillis(AbstractTransportManager.getParamAsNum(parameters, "database-" + batchId));
        batchInfo.setByteCount(AbstractTransportManager.getParamAsNum(parameters, "byteCount-" + batchId));
        String status = AbstractTransportManager.getParam(parameters, "batch-" + batchId, "").trim();
        batchInfo.setOk(status.equalsIgnoreCase("ok"));
        if (!batchInfo.isOk()) {
            batchInfo.setErrorLine(NumberUtils.toLong((String)status));
            batchInfo.setSqlState(AbstractTransportManager.getParam(parameters, "sqlState-" + batchId));
            batchInfo.setSqlCode((int)AbstractTransportManager.getParamAsNum(parameters, "sqlCode-" + batchId));
            batchInfo.setSqlMessage(AbstractTransportManager.getParam(parameters, "sqlMessage-" + batchId));
        }
        return batchInfo;
    }

    protected static Map<String, Object> getParametersFromQueryUrl(String parameterString) throws IOException {
        String[] tokens;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String param : tokens = parameterString.split("&")) {
            String[] nameValuePair = param.split("=");
            if (nameValuePair.length != 2) continue;
            parameters.put(nameValuePair[0], URLDecoder.decode(nameValuePair[1], "UTF-8"));
        }
        return parameters;
    }

    private static long getParamAsNum(Map<String, Object> parameters, String parameterName) {
        return NumberUtils.toLong((String)AbstractTransportManager.getParam(parameters, parameterName));
    }

    private static String getParam(Map<String, Object> parameters, String parameterName, String defaultValue) {
        String value = AbstractTransportManager.getParam(parameters, parameterName);
        return value == null ? defaultValue : value;
    }

    private static String getParam(Map<String, Object> parameters, String parameterName) {
        String[] arrayValue;
        Object value = parameters.get(parameterName);
        if (value instanceof String[] && (arrayValue = (String[])value).length > 0) {
            value = StringUtils.trim((String)arrayValue[0]);
        }
        return (String)value;
    }
}

