/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.statistic;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.INotificationService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IStatisticService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.statistic.Statistic;
import org.jumpmind.symmetric.statistic.StatisticAlertThresholds;

public class StatisticManager
implements IStatisticManager {
    Map<String, Statistic> statistics;
    INodeService nodeService;
    IStatisticService statisticService;
    INotificationService notificationService;
    IParameterService parameterService;
    Date lastCaptureEndTime;

    public synchronized void init() {
        if (this.statistics == null) {
            this.refresh(new Date());
        }
    }

    public synchronized void flush() {
        Date captureEndTime = new Date();
        if (this.statistics != null) {
            this.statisticService.save(this.statistics.values(), captureEndTime);
            this.publishAlerts();
        }
        this.refresh(captureEndTime);
    }

    protected synchronized void publishAlerts() {
        List<StatisticAlertThresholds> thresholds;
        if (this.parameterService.is("statistic.threshold.alerts.enabled") && this.statistics != null && (thresholds = this.statisticService.getAlertThresholds()) != null) {
            for (StatisticAlertThresholds statisticAlertThresholds : thresholds) {
                Notification event;
                String name = statisticAlertThresholds.getStatisticName();
                if (name == null || (event = statisticAlertThresholds.outsideOfBoundsNotification(this.statistics.get(name))) == null) continue;
                this.notificationService.sendNotification(event);
            }
        }
    }

    protected synchronized void refresh(Date lastCaptureEndTime) {
        if (this.statistics == null) {
            this.statistics = new HashMap<String, Statistic>();
        }
        this.lastCaptureEndTime = lastCaptureEndTime;
        this.statistics.clear();
    }

    public Statistic getStatistic(String statisticName) {
        this.init();
        Statistic statistic = this.statistics.get(statisticName);
        if (statistic == null) {
            Node node = this.nodeService.findIdentity();
            String nodeId = "Unknown";
            if (node != null) {
                nodeId = node.getNodeId();
            }
            statistic = new Statistic(statisticName, nodeId, this.lastCaptureEndTime == null ? new Date() : this.lastCaptureEndTime);
            this.statistics.put(statisticName, statistic);
        }
        return statistic;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setStatisticService(IStatisticService statisticService) {
        this.statisticService = statisticService;
    }

    public void setNotificationService(INotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

