/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.statistic;

import java.math.BigDecimal;
import javax.management.Notification;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jumpmind.symmetric.statistic.Statistic;

public class StatisticAlertThresholds {
    String statisticName;
    BigDecimal thresholdTotalMax;
    Long thresholdCountMax;
    BigDecimal thresholdTotalMin;
    Long thresholdCountMin;
    BigDecimal thresholdAvgMax;
    BigDecimal thresholdAvgMin;
    static long sequenceNumber = System.currentTimeMillis();

    public StatisticAlertThresholds() {
    }

    public StatisticAlertThresholds(String statisticName, BigDecimal threshholdTotalMax, Long threshholdCountMax, BigDecimal threshholdTotalMin, Long threshholdCountMin, BigDecimal threshholdAvgMax, BigDecimal threshholdAvgMin) {
        this.statisticName = statisticName;
        this.thresholdTotalMax = threshholdTotalMax;
        this.thresholdCountMax = threshholdCountMax;
        this.thresholdTotalMin = threshholdTotalMin;
        this.thresholdCountMin = threshholdCountMin;
        this.thresholdAvgMax = threshholdAvgMax;
        this.thresholdAvgMin = threshholdAvgMin;
    }

    public String getStatisticName() {
        return this.statisticName;
    }

    public void setStatisticName(String statisticName) {
        this.statisticName = statisticName;
    }

    public BigDecimal getThresholdTotalMax() {
        return this.thresholdTotalMax == null ? BigDecimal.ZERO : this.thresholdTotalMax;
    }

    public void setThresholdTotalMax(BigDecimal threshholdTotalMax) {
        this.thresholdTotalMax = threshholdTotalMax;
    }

    public Long getThresholdCountMax() {
        return this.thresholdCountMax == null ? 0L : this.thresholdCountMax;
    }

    public void setThresholdCountMax(Long threshholdCountMax) {
        this.thresholdCountMax = threshholdCountMax;
    }

    public BigDecimal getThresholdTotalMin() {
        return this.thresholdTotalMin == null ? BigDecimal.ZERO : this.thresholdTotalMin;
    }

    public void setThresholdTotalMin(BigDecimal threshholdTotalMin) {
        this.thresholdTotalMin = threshholdTotalMin;
    }

    public Long getThresholdCountMin() {
        return this.thresholdCountMin == null ? 0L : this.thresholdCountMin;
    }

    public void setThresholdCountMin(Long threshholdCountMin) {
        this.thresholdCountMin = threshholdCountMin;
    }

    public Notification outsideOfBoundsNotification(Statistic stats) {
        if (stats != null && stats.getName().equals(this.statisticName)) {
            boolean createNotification = false;
            StringBuilder msg = new StringBuilder(this.statisticName);
            long count = stats.getCount();
            BigDecimal total = stats.getTotal();
            BigDecimal avg = stats.getAverageValue();
            if (this.thresholdCountMax != null && this.thresholdCountMax > 0L && count > this.thresholdCountMax || this.thresholdCountMin != null && this.thresholdCountMin > 0L && count < this.thresholdCountMin) {
                msg.append(":count=");
                msg.append(count);
                createNotification = true;
            }
            if (this.thresholdTotalMax != null && this.thresholdTotalMax.compareTo(BigDecimal.ZERO) > 0 && total.compareTo(this.thresholdTotalMax) > 0 || this.thresholdTotalMin != null && this.thresholdTotalMin.compareTo(BigDecimal.ZERO) > 0 && total.compareTo(this.thresholdTotalMin) < 0) {
                msg.append(":total=");
                msg.append(total);
                createNotification = true;
            }
            if (this.thresholdAvgMax != null && this.thresholdAvgMax.compareTo(BigDecimal.ZERO) > 0 && avg.compareTo(this.thresholdAvgMax) > 0 || this.thresholdAvgMin != null && this.thresholdAvgMin.compareTo(BigDecimal.ZERO) > 0 && avg.compareTo(this.thresholdAvgMin) < 0) {
                msg.append(":avg=");
                msg.append(avg);
                createNotification = true;
            }
            if (createNotification) {
                return new Notification("SymmetricDS:Alert", stats, sequenceNumber++, System.currentTimeMillis(), msg.toString());
            }
        }
        return null;
    }

    public BigDecimal getThresholdAvgMax() {
        return this.thresholdAvgMax == null ? BigDecimal.ZERO : this.thresholdAvgMax;
    }

    public void setThresholdAvgMax(BigDecimal threshholdAvgMax) {
        this.thresholdAvgMax = threshholdAvgMax;
    }

    public BigDecimal getThresholdAvgMin() {
        return this.thresholdAvgMin == null ? BigDecimal.ZERO : this.thresholdAvgMin;
    }

    public void setThresholdAvgMin(BigDecimal threshholdAvgMin) {
        this.thresholdAvgMin = threshholdAvgMin;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.statisticName).append((Object)this.getThresholdTotalMax()).append((Object)this.getThresholdCountMax()).append((Object)this.getThresholdTotalMin()).append((Object)this.getThresholdCountMin()).append((Object)this.getThresholdAvgMax()).append((Object)this.getThresholdAvgMin()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatisticAlertThresholds)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        StatisticAlertThresholds rhs = (StatisticAlertThresholds)obj;
        return new EqualsBuilder().append((Object)this.statisticName, (Object)rhs.statisticName).append((Object)this.getThresholdTotalMax(), (Object)rhs.getThresholdTotalMax()).append((Object)this.getThresholdCountMax(), (Object)rhs.getThresholdCountMax()).append((Object)this.getThresholdTotalMin(), (Object)rhs.getThresholdTotalMin()).append((Object)this.getThresholdCountMin(), (Object)rhs.getThresholdCountMin()).append((Object)this.getThresholdAvgMax(), (Object)rhs.getThresholdAvgMax()).append((Object)this.getThresholdAvgMin(), (Object)rhs.getThresholdAvgMin()).isEquals();
    }
}

