/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.statistic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Statistic {
    private String name;
    private String nodeId;
    private Date captureStartTimeMs;
    private BigDecimal total;
    private long count;
    private static Map<String, BigDecimal> lifeTimeTotal = new HashMap<String, BigDecimal>();
    private static Map<String, Long> lifeTimeCount = new HashMap<String, Long>();

    public Statistic(String name, String nodeId) {
        this(name, nodeId, new Date());
    }

    public Statistic(String name, String nodeId, Date startTime) {
        this.name = name;
        this.nodeId = nodeId;
        this.captureStartTimeMs = startTime;
        this.total = BigDecimal.ZERO;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public BigDecimal getLifetimeTotal() {
        return lifeTimeTotal.get(this.name);
    }

    public long getLifetimeCount() {
        return lifeTimeCount.get(this.name);
    }

    public BigDecimal getLifetimeAverageValue() {
        return this.getAverageValue(this.getLifetimeTotal(), this.getLifetimeCount());
    }

    public BigDecimal getAverageValue() {
        return this.getAverageValue(this.total, this.count);
    }

    private BigDecimal getAverageValue(BigDecimal total, long count) {
        if (total != null && total.compareTo(BigDecimal.ZERO) > 0 && count > 0L) {
            return total.divide(new BigDecimal(count), RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }

    public void increment() {
        this.add(1, 1L);
    }

    public void add(int v) {
        this.add(v, 1L);
    }

    public void add(BigDecimal v) {
        this.add(v, 1L);
    }

    public void add(long v) {
        this.add(v, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long v, long count) {
        String string = this.name;
        synchronized (string) {
            this.total = this.total.add(new BigDecimal(v));
            this.count += count;
            lifeTimeCount.put(this.name, new Long((lifeTimeCount.containsKey(this.name) ? lifeTimeCount.get(this.name) : 0L) + count));
            lifeTimeTotal.put(this.name, lifeTimeTotal.containsKey(this.name) ? lifeTimeTotal.get(this.name).add(new BigDecimal(v)) : new BigDecimal(v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int v, long count) {
        String string = this.name;
        synchronized (string) {
            this.total = this.total.add(new BigDecimal(v));
            this.count += count;
            lifeTimeCount.put(this.name, new Long((lifeTimeCount.containsKey(this.name) ? lifeTimeCount.get(this.name) : 0L) + count));
            lifeTimeTotal.put(this.name, lifeTimeTotal.containsKey(this.name) ? lifeTimeTotal.get(this.name).add(new BigDecimal(v)) : new BigDecimal(v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BigDecimal v, long count) {
        String string = this.name;
        synchronized (string) {
            this.total = this.total.add(v);
            this.count += count;
            lifeTimeCount.put(this.name, new Long((lifeTimeCount.containsKey(this.name) ? lifeTimeCount.get(this.name) : 0L) + count));
            lifeTimeTotal.put(this.name, lifeTimeTotal.containsKey(this.name) ? lifeTimeTotal.get(this.name).add(v) : v);
        }
    }

    public Date getCaptureStartTimeMs() {
        return this.captureStartTimeMs;
    }

    public long getCount() {
        return this.count;
    }
}

