/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IUpgradeService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.upgrade.IUpgradeTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeService
extends AbstractService
implements IUpgradeService {
    private INodeService nodeService;
    private Map<String, List<IUpgradeTask>> upgradeTaskMap;

    @Override
    public boolean isUpgradeNecessary() {
        int[] fromVersion;
        String nodeId;
        boolean isUpgradeNecessary = false;
        String symmetricVersion = this.nodeService.findSymmetricVersion();
        if (!(StringUtils.isBlank((String)symmetricVersion) || symmetricVersion.equals("development") || !Version.isOlderVersion(symmetricVersion) || (nodeId = this.nodeService.findIdentityNodeId()) == null || (isUpgradeNecessary = this.doUpgradeTasksExist(nodeId, fromVersion = Version.parseVersion(symmetricVersion))) || this.parameterService.is("auto.config.database"))) {
            this.log.warn("UpgradeWarning", "auto.config.database");
        }
        return isUpgradeNecessary;
    }

    @Override
    public boolean isUpgradePossible() {
        String symmetricVersion = this.nodeService.findSymmetricVersion();
        if (!StringUtils.isBlank((String)symmetricVersion) && !symmetricVersion.equals("development")) {
            return Version.parseVersion(symmetricVersion)[0] > 1;
        }
        return true;
    }

    @Override
    public void upgrade() {
        String symmetricVersion = this.nodeService.findSymmetricVersion();
        String nodeId = this.nodeService.findIdentityNodeId();
        if (symmetricVersion != null && nodeId != null) {
            int[] fromVersion = Version.parseVersion(symmetricVersion);
            if (Version.isOlderVersion(symmetricVersion)) {
                this.runUpgrade(nodeId, fromVersion);
                Node node = this.nodeService.findIdentity();
                node.setSymmetricVersion(Version.version());
                this.nodeService.updateNode(node);
            }
        } else {
            this.log.warn("NodeUpgradeFailed");
        }
    }

    protected boolean doUpgradeTasksExist(String nodeId, int[] fromVersion) {
        String majorMinorVersion = fromVersion[0] + "." + fromVersion[1];
        List<IUpgradeTask> upgradeTaskList = this.upgradeTaskMap.get(majorMinorVersion);
        return upgradeTaskList != null && upgradeTaskList.size() > 0;
    }

    private void runUpgrade(String nodeId, int[] fromVersion) {
        String majorMinorVersion = fromVersion[0] + "." + fromVersion[1];
        List<IUpgradeTask> upgradeTaskList = this.upgradeTaskMap.get(majorMinorVersion);
        this.log.warn("NodeUpgradeStarting", majorMinorVersion, Version.version());
        boolean isRegistrationServer = StringUtils.isEmpty((String)this.parameterService.getRegistrationUrl());
        if (upgradeTaskList != null) {
            for (IUpgradeTask upgradeTask : upgradeTaskList) {
                if ((!isRegistrationServer || !upgradeTask.isUpgradeRegistrationServer()) && (isRegistrationServer || !upgradeTask.isUpgradeNonRegistrationServer())) continue;
                upgradeTask.upgrade(nodeId, this.parameterService, fromVersion);
            }
        }
        this.log.warn("NodeUpgradeCompleted");
    }

    public void setUpgradeTaskMap(Map<String, List<IUpgradeTask>> upgradeTaskMap) {
        this.upgradeTaskMap = upgradeTaskMap;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }
}

