/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.model.Table;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.config.ITriggerCreationListener;
import org.jumpmind.symmetric.config.TriggerFailureListener;
import org.jumpmind.symmetric.config.TriggerSelector;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerReBuildReason;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerRouterService
extends AbstractService
implements ITriggerRouterService {
    private Map<String, List<String>> rootConfigChannelTableNames;
    private Map<String, Map<String, String>> rootConfigChannelInitialLoadSelect;
    private IClusterService clusterService;
    private IConfigurationService configurationService;
    private Map<String, TriggerRoutersCache> triggerRouterCacheByNodeGroupId = new HashMap<String, TriggerRoutersCache>();
    private long triggerRouterCacheTime;
    private List<ITriggerCreationListener> triggerCreationListeners;
    private TriggerFailureListener failureListener = new TriggerFailureListener();
    private HashMap<Integer, TriggerHistory> historyMap = new HashMap();

    public TriggerRouterService() {
        this.addTriggerCreationListeners(this.failureListener);
    }

    @Override
    public void inactivateTriggerHistory(TriggerHistory history) {
        this.jdbcTemplate.update(this.getSql("inactivateTriggerHistorySql"), new Object[]{history.getTriggerHistoryId()});
    }

    @Override
    public Map<Long, TriggerHistory> getHistoryRecords() {
        HashMap<Long, TriggerHistory> retMap = new HashMap<Long, TriggerHistory>();
        this.jdbcTemplate.query(this.getSql("allTriggerHistSql"), (RowMapper)new TriggerHistoryMapper(retMap));
        return retMap;
    }

    protected boolean isTriggerNameInUse(String triggerId, String triggerName) {
        return this.jdbcTemplate.queryForInt(this.getSql("selectTriggerNameInUseSql"), new Object[]{triggerName, triggerName, triggerName, triggerId}) > 0;
    }

    @Override
    public TriggerHistory findTriggerHistory(String sourceTableName) {
        HashMap<Long, TriggerHistory> retMap = new HashMap<Long, TriggerHistory>();
        this.jdbcTemplate.query(String.format("%s%s", this.getSqlPrefix("allTriggerHistSql"), this.getSql("triggerHistBySourceTableWhereSql")), new Object[]{sourceTableName}, new int[]{12}, (RowMapper)new TriggerHistoryMapper(retMap));
        if (retMap.size() > 0) {
            return (TriggerHistory)retMap.values().iterator().next();
        }
        return null;
    }

    @Override
    public TriggerHistory getTriggerHistory(int histId) {
        TriggerHistory history = this.historyMap.get(histId);
        if (history == null && histId >= 0) {
            try {
                history = (TriggerHistory)this.jdbcTemplate.queryForObject(this.getSql("triggerHistSql"), new Object[]{histId}, (RowMapper)new TriggerHistoryMapper());
                this.historyMap.put(histId, history);
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                // empty catch block
            }
        }
        return history;
    }

    @Override
    public TriggerHistory getNewestTriggerHistoryForTrigger(String triggerId) {
        try {
            return (TriggerHistory)this.jdbcTemplate.queryForObject(this.getSql("latestTriggerHistSql"), new Object[]{triggerId}, (RowMapper)new TriggerHistoryMapper());
        }
        catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }

    protected List<TriggerHistory> getActiveTriggerHistoriesForInactivation() {
        List hists = this.jdbcTemplate.query(this.getSqlPrefix("allTriggerHistSql") + this.getSql("inactiveTriggerHistoryWhereSql"), new Object[]{this.parameterService.getNodeGroupId()}, (RowMapper)new TriggerHistoryMapper());
        Iterator iterator = hists.iterator();
        while (iterator.hasNext()) {
            TriggerHistory triggerHistory = (TriggerHistory)iterator.next();
            if (!triggerHistory.getSourceTableName().toLowerCase().startsWith(this.tablePrefix + "_")) continue;
            iterator.remove();
        }
        return hists;
    }

    @Override
    public List<TriggerRouter> getTriggerRoutersForRegistration(String version, String sourceGroupId, String targetGroupId) {
        int initialLoadOrder = 1;
        String majorVersion = Integer.toString(Version.parseVersion(version)[0]);
        List<String> tables = this.rootConfigChannelTableNames.get(majorVersion);
        ArrayList<TriggerRouter> triggers = new ArrayList<TriggerRouter>(tables.size());
        for (int j = 0; j < tables.size(); ++j) {
            String tableName = tables.get(j);
            boolean syncChanges = !TableConstants.getNodeTablesAsSet(this.tablePrefix).contains(tableName);
            TriggerRouter trigger = this.buildRegistrationTriggerRouter(version, tableName, syncChanges, sourceGroupId, targetGroupId);
            trigger.setInitialLoadOrder(initialLoadOrder++);
            String initialLoadSelect = this.rootConfigChannelInitialLoadSelect.get(majorVersion).get(tableName);
            trigger.setInitialLoadSelect(initialLoadSelect);
            if (tableName.equalsIgnoreCase(TableConstants.getTableName(this.tablePrefix, "trigger"))) {
                trigger.getRouter().setRouterType("trigger");
            }
            triggers.add(trigger);
        }
        return triggers;
    }

    protected TriggerRouter buildRegistrationTriggerRouter(String version, String tableName, boolean syncChanges, String sourceGroupId, String targetGroupId) {
        String majorVersion = Integer.toString(Version.parseVersion(version)[0]);
        boolean autoSyncConfig = this.parameterService.is("auto.sync.configuration");
        TriggerRouter triggerRouter = new TriggerRouter();
        triggerRouter.setInitialLoadSelect(this.rootConfigChannelInitialLoadSelect.get(majorVersion).get(tableName));
        Trigger trigger = triggerRouter.getTrigger();
        trigger.setTriggerId(Integer.toString(Math.abs(tableName.hashCode() + targetGroupId.hashCode())));
        trigger.setSyncOnDelete(syncChanges && autoSyncConfig);
        trigger.setSyncOnInsert(syncChanges && autoSyncConfig);
        trigger.setSyncOnUpdate(syncChanges && autoSyncConfig);
        trigger.setSyncOnIncomingBatch(true);
        trigger.setSourceTableName(tableName);
        trigger.setChannelId("config");
        Router router = triggerRouter.getRouter();
        router.setSourceNodeGroupId(sourceGroupId);
        router.setTargetNodeGroupId(targetGroupId);
        trigger.setLastUpdateTime(new Date(Version.version().hashCode()));
        router.setLastUpdateTime(trigger.getLastUpdateTime());
        triggerRouter.setLastUpdateTime(trigger.getLastUpdateTime());
        return triggerRouter;
    }

    private String getTriggerRouterSqlPrefix() {
        return this.getSqlPrefix("selectTriggerRouterPrefixSql");
    }

    @Override
    public TriggerRouter findTriggerRouterForCurrentNode(String table) {
        String nodeGroupId = this.parameterService.getNodeGroupId();
        List configs = this.jdbcTemplate.query(this.getTriggerRouterSqlPrefix() + this.getSql("selectTriggerSql"), new Object[]{table, nodeGroupId}, (RowMapper)new TriggerRouterMapper());
        if (configs.size() > 0) {
            return (TriggerRouter)configs.get(0);
        }
        List<TriggerRouter> triggers = this.getAllTriggerRoutersForCurrentNode(nodeGroupId);
        for (TriggerRouter trigger : triggers) {
            if (!trigger.getTrigger().getSourceTableName().equalsIgnoreCase(table)) continue;
            return trigger;
        }
        return null;
    }

    protected List<TriggerRouter> getConfigurationTablesTriggerRoutersForCurrentNode(String sourceNodeGroupId) {
        ArrayList<TriggerRouter> triggers = new ArrayList<TriggerRouter>();
        List<NodeGroupLink> links = this.configurationService.getGroupLinksFor(sourceNodeGroupId);
        for (NodeGroupLink nodeGroupLink : links) {
            if (nodeGroupLink.getDataEventAction().equals((Object)NodeGroupLinkAction.W)) {
                triggers.addAll(this.getTriggerRoutersForRegistration(Version.version(), nodeGroupLink.getSourceNodeGroupId(), nodeGroupLink.getTargetNodeGroupId()));
                continue;
            }
            if (nodeGroupLink.getDataEventAction().equals((Object)NodeGroupLinkAction.P)) {
                triggers.add(this.buildRegistrationTriggerRouter(Version.version(), TableConstants.getTableName(this.tablePrefix, "node"), false, nodeGroupLink.getSourceNodeGroupId(), nodeGroupLink.getTargetNodeGroupId()));
                this.log.debug("TriggerHistCreating", TableConstants.getTableName(this.tablePrefix, "node"));
                triggers.add(this.buildRegistrationTriggerRouter(Version.version(), TableConstants.getTableName(this.tablePrefix, "node_host"), true, nodeGroupLink.getSourceNodeGroupId(), nodeGroupLink.getTargetNodeGroupId()));
                this.log.debug("TriggerHistCreating", TableConstants.getTableName(this.tablePrefix, "node_host"));
                continue;
            }
            this.log.warn("TriggerConfigurationCreatingFailed", new Object[]{sourceNodeGroupId, nodeGroupLink.getDataEventAction()});
        }
        return triggers;
    }

    protected void mergeInConfigurationTablesTriggerRoutersForCurrentNode(String sourceNodeGroupId, List<TriggerRouter> configuredInDatabase) {
        List<TriggerRouter> virtualConfigTriggers = this.getConfigurationTablesTriggerRoutersForCurrentNode(sourceNodeGroupId);
        for (TriggerRouter trigger : virtualConfigTriggers) {
            if (!trigger.getRouter().getSourceNodeGroupId().equalsIgnoreCase(sourceNodeGroupId) || this.doesTriggerRouterExistInList(configuredInDatabase, trigger)) continue;
            configuredInDatabase.add(trigger);
        }
    }

    protected boolean doesTriggerRouterExistInList(List<TriggerRouter> triggerRouters, TriggerRouter triggerRouter) {
        for (TriggerRouter checkMe : triggerRouters) {
            if (!checkMe.isSame(triggerRouter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, List<TriggerRouter>> getTriggerRoutersForCurrentNode(boolean refreshCache) {
        return this.getTriggerRoutersCacheForCurrentNode((boolean)refreshCache).triggerRoutersByTriggerId;
    }

    @Override
    public TriggerRouter getTriggerRouterForTableForCurrentNode(String tableName, boolean refreshCache) {
        return this.getTriggerRouterForTableForCurrentNode(null, tableName, refreshCache);
    }

    @Override
    public TriggerRouter getTriggerRouterForTableForCurrentNode(NodeGroupLink link, String tableName, boolean refreshCache) {
        TriggerRoutersCache cache = this.getTriggerRoutersCacheForCurrentNode(refreshCache);
        Collection<List<TriggerRouter>> triggerRouters = cache.triggerRoutersByTriggerId.values();
        for (List<TriggerRouter> list : triggerRouters) {
            for (TriggerRouter triggerRouter : list) {
                if (!this.isMatch(link, triggerRouter) || !triggerRouter.getTrigger().getSourceTableName().equals(tableName)) continue;
                return triggerRouter;
            }
        }
        return null;
    }

    protected boolean isMatch(NodeGroupLink link, TriggerRouter router) {
        if (link != null && router != null && router.getRouter() != null) {
            return link.getSourceNodeGroupId().equals(router.getRouter().getSourceNodeGroupId()) && link.getTargetNodeGroupId().equals(router.getRouter().getTargetNodeGroupId());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TriggerRoutersCache getTriggerRoutersCacheForCurrentNode(boolean refreshCache) {
        String myNodeGroupId = this.parameterService.getNodeGroupId();
        long triggerRouterCacheTimeoutInMs = this.parameterService.getLong("cache.trigger.router.time.ms");
        if (System.currentTimeMillis() - this.triggerRouterCacheTime > triggerRouterCacheTimeoutInMs) {
            this.resetTriggerRouterCacheByNodeGroupId();
        }
        if (!this.triggerRouterCacheByNodeGroupId.containsKey(myNodeGroupId) || refreshCache) {
            TriggerRouterService triggerRouterService = this;
            synchronized (triggerRouterService) {
                List<TriggerRouter> triggerRouters = this.getAllTriggerRoutersForCurrentNode(myNodeGroupId);
                HashMap<String, List<TriggerRouter>> triggerRoutersByTriggerId = new HashMap<String, List<TriggerRouter>>(triggerRouters.size());
                HashMap<String, Router> routers = new HashMap<String, Router>(triggerRouters.size());
                for (TriggerRouter triggerRouter : triggerRouters) {
                    String triggerId = triggerRouter.getTrigger().getTriggerId();
                    ArrayList<TriggerRouter> list = (ArrayList<TriggerRouter>)triggerRoutersByTriggerId.get(triggerId);
                    if (list == null) {
                        list = new ArrayList<TriggerRouter>();
                        triggerRoutersByTriggerId.put(triggerId, list);
                    }
                    list.add(triggerRouter);
                    routers.put(triggerRouter.getRouter().getRouterId(), triggerRouter.getRouter());
                }
                this.triggerRouterCacheByNodeGroupId.put(myNodeGroupId, new TriggerRoutersCache(triggerRoutersByTriggerId, routers));
            }
        }
        return this.triggerRouterCacheByNodeGroupId.get(myNodeGroupId);
    }

    @Override
    public Router getRouterByIdForCurrentNode(String routerId, boolean refreshCache) {
        return this.getTriggerRoutersCacheForCurrentNode((boolean)refreshCache).routersByRouterId.get(routerId);
    }

    @Override
    public List<TriggerRouter> getAllTriggerRoutersForCurrentNode(String sourceNodeGroupId) {
        List triggers = this.jdbcTemplate.query(this.getTriggerRouterSqlPrefix() + this.getSql("activeTriggersForSourceNodeGroupSql"), new Object[]{sourceNodeGroupId}, (RowMapper)new TriggerRouterMapper());
        this.mergeInConfigurationTablesTriggerRoutersForCurrentNode(sourceNodeGroupId, triggers);
        return triggers;
    }

    @Override
    public List<TriggerRouter> getAllTriggerRoutersForReloadForCurrentNode(String sourceNodeGroupId, String targetNodeGroupId) {
        return this.jdbcTemplate.query(this.getTriggerRouterSqlPrefix() + this.getSql("activeTriggersForReloadSql"), new Object[]{sourceNodeGroupId, targetNodeGroupId, "config"}, (RowMapper)new TriggerRouterMapper());
    }

    @Override
    public TriggerRouter findTriggerRouter(String table, String sourceNodeGroupId, String targetNodeGroupId, String channel) {
        List configs = this.jdbcTemplate.query(this.getTriggerRouterSqlPrefix() + this.getSql("selectTriggerTargetSql"), new Object[]{table, targetNodeGroupId, channel, sourceNodeGroupId}, (RowMapper)new TriggerRouterMapper());
        if (configs.size() > 0) {
            return (TriggerRouter)configs.get(0);
        }
        return null;
    }

    @Override
    public TriggerRouter findTriggerRouterById(String triggerId, String routerId) {
        List configs = this.jdbcTemplate.query(this.getTriggerRouterSqlPrefix() + this.getSql("selectTriggerRouterSql"), new Object[]{triggerId, routerId}, (RowMapper)new TriggerRouterMapper());
        if (configs.size() > 0) {
            return (TriggerRouter)configs.get(0);
        }
        return null;
    }

    @Override
    public Trigger getTriggerById(String triggerId) {
        List triggers = this.jdbcTemplate.query(this.getTriggerRouterSqlPrefix() + this.getSql("selectTriggerByIdSql"), new Object[]{triggerId}, (RowMapper)new TriggerRouterMapper());
        if (triggers.size() > 0) {
            return ((TriggerRouter)triggers.get(0)).getTrigger();
        }
        return null;
    }

    @Override
    public Map<String, List<TriggerRouter>> getTriggerRoutersByChannel(String nodeGroupId) {
        final HashMap<String, List<TriggerRouter>> retMap = new HashMap<String, List<TriggerRouter>>();
        this.jdbcTemplate.query(this.getTriggerRouterSqlPrefix() + this.getSql("selectGroupTriggersSql"), new Object[]{nodeGroupId}, (RowMapper)new TriggerRouterMapper(){

            public TriggerRouter mapRow(ResultSet rs, int arg1) throws SQLException {
                TriggerRouter config = super.mapRow(rs, arg1);
                ArrayList<TriggerRouter> list = (ArrayList<TriggerRouter>)retMap.get(config.getTrigger().getChannelId());
                if (list == null) {
                    list = new ArrayList<TriggerRouter>();
                    retMap.put(config.getTrigger().getChannelId(), list);
                }
                list.add(config);
                return config;
            }
        });
        return retMap;
    }

    @Override
    public void insert(TriggerHistory newHistRecord) {
        this.jdbcTemplate.update(this.getSql("insertTriggerHistorySql"), new Object[]{newHistRecord.getTriggerId(), newHistRecord.getSourceTableName(), newHistRecord.getTableHash(), newHistRecord.getCreateTime(), newHistRecord.getColumnNames(), newHistRecord.getPkColumnNames(), newHistRecord.getLastTriggerBuildReason().getCode(), newHistRecord.getNameForDeleteTrigger(), newHistRecord.getNameForInsertTrigger(), newHistRecord.getNameForUpdateTrigger(), newHistRecord.getSourceSchemaName(), newHistRecord.getSourceCatalogName(), newHistRecord.getTriggerRowHash()}, new int[]{12, 12, -5, 93, 12, 12, 1, 12, 12, 12, 12, 12, -5});
    }

    @Override
    public void saveTriggerRouter(TriggerRouter triggerRouter) {
        this.saveTrigger(triggerRouter.getTrigger());
        this.saveRouter(triggerRouter.getRouter());
        triggerRouter.setLastUpdateTime(new Date());
        if (0 == this.jdbcTemplate.update(this.getSql("updateTriggerRouterSql"), new Object[]{triggerRouter.getInitialLoadOrder(), triggerRouter.getInitialLoadSelect(), triggerRouter.getLastUpdateBy(), triggerRouter.getLastUpdateTime(), triggerRouter.getTrigger().getTriggerId(), triggerRouter.getRouter().getRouterId()}, new int[]{2, 12, 12, 93, 12, 12})) {
            triggerRouter.setCreateTime(triggerRouter.getLastUpdateTime());
            this.jdbcTemplate.update(this.getSql("insertTriggerRouterSql"), new Object[]{triggerRouter.getInitialLoadOrder(), triggerRouter.getInitialLoadSelect(), triggerRouter.getCreateTime(), triggerRouter.getLastUpdateBy(), triggerRouter.getLastUpdateTime(), triggerRouter.getTrigger().getTriggerId(), triggerRouter.getRouter().getRouterId()}, new int[]{2, 12, 93, 12, 93, 12, 12});
        }
    }

    protected synchronized void resetTriggerRouterCacheByNodeGroupId() {
        this.triggerRouterCacheByNodeGroupId.clear();
        this.triggerRouterCacheTime = System.currentTimeMillis();
    }

    @Override
    public void saveRouter(Router router) {
        router.setLastUpdateTime(new Date());
        if (0 == this.jdbcTemplate.update(this.getSql("updateRouterSql"), new Object[]{router.getTargetCatalogName(), router.getTargetSchemaName(), router.getTargetTableName(), router.getSourceNodeGroupId(), router.getTargetNodeGroupId(), router.getRouterType(), router.getRouterExpression(), router.isSyncOnUpdate() ? 1 : 0, router.isSyncOnInsert() ? 1 : 0, router.isSyncOnDelete() ? 1 : 0, router.getLastUpdateBy(), router.getLastUpdateTime(), router.getRouterId()}, new int[]{12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 93, 12})) {
            router.setCreateTime(router.getLastUpdateTime());
            this.jdbcTemplate.update(this.getSql("insertRouterSql"), new Object[]{router.getTargetCatalogName(), router.getTargetSchemaName(), router.getTargetTableName(), router.getSourceNodeGroupId(), router.getTargetNodeGroupId(), router.getRouterType(), router.getRouterExpression(), router.isSyncOnUpdate() ? 1 : 0, router.isSyncOnInsert() ? 1 : 0, router.isSyncOnDelete() ? 1 : 0, router.getCreateTime(), router.getLastUpdateBy(), router.getLastUpdateTime(), router.getRouterId()}, new int[]{12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 93, 12, 93, 12});
        }
        this.resetTriggerRouterCacheByNodeGroupId();
    }

    @Override
    public void saveTrigger(Trigger trigger) {
        trigger.setLastUpdateTime(new Date());
        if (0 == this.jdbcTemplate.update(this.getSql("updateTriggerSql"), new Object[]{trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), trigger.getChannelId(), trigger.isSyncOnUpdate() ? 1 : 0, trigger.isSyncOnInsert() ? 1 : 0, trigger.isSyncOnDelete() ? 1 : 0, trigger.isSyncOnIncomingBatch() ? 1 : 0, trigger.getNameForUpdateTrigger(), trigger.getNameForInsertTrigger(), trigger.getNameForDeleteTrigger(), trigger.getSyncOnUpdateCondition(), trigger.getSyncOnInsertCondition(), trigger.getSyncOnDeleteCondition(), trigger.getTxIdExpression(), trigger.getExcludedColumnNames(), trigger.getLastUpdateBy(), trigger.getLastUpdateTime(), trigger.getExternalSelect(), trigger.getTriggerId()}, new int[]{12, 12, 12, 12, 5, 5, 5, 5, 12, 12, 12, 12, 12, 12, 12, 12, 12, 93, 12, 12})) {
            trigger.setCreateTime(trigger.getLastUpdateTime());
            this.jdbcTemplate.update(this.getSql("insertTriggerSql"), new Object[]{trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), trigger.getChannelId(), trigger.isSyncOnUpdate() ? 1 : 0, trigger.isSyncOnInsert() ? 1 : 0, trigger.isSyncOnDelete() ? 1 : 0, trigger.isSyncOnIncomingBatch() ? 1 : 0, trigger.getNameForUpdateTrigger(), trigger.getNameForInsertTrigger(), trigger.getNameForDeleteTrigger(), trigger.getSyncOnUpdateCondition(), trigger.getSyncOnInsertCondition(), trigger.getSyncOnDeleteCondition(), trigger.getTxIdExpression(), trigger.getExcludedColumnNames(), trigger.getCreateTime(), trigger.getLastUpdateBy(), trigger.getLastUpdateTime(), trigger.getExternalSelect(), trigger.getTriggerId()}, new int[]{12, 12, 12, 12, 5, 5, 5, 5, 12, 12, 12, 12, 12, 12, 12, 12, 93, 12, 93, 12, 12});
        }
    }

    @Override
    public void syncTriggers() {
        this.syncTriggers(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncTriggers(StringBuilder sqlBuffer, boolean gen_always) {
        if (this.clusterService.lock("SYNCTRIGGERS")) {
            TriggerRouterService triggerRouterService = this;
            synchronized (triggerRouterService) {
                try {
                    this.log.info("TriggersSynchronizing");
                    this.configurationService.reloadChannels();
                    this.inactivateTriggers(sqlBuffer);
                    this.updateOrCreateDatabaseTriggers(sqlBuffer, gen_always);
                    this.resetTriggerRouterCacheByNodeGroupId();
                    Object var5_4 = null;
                    this.clusterService.unlock("SYNCTRIGGERS");
                    this.log.info("TriggersSynchronized");
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.clusterService.unlock("SYNCTRIGGERS");
                    this.log.info("TriggersSynchronized");
                    throw throwable;
                }
            }
        }
        this.log.info("TriggersSynchronizingFailedLock");
    }

    protected void inactivateTriggers(StringBuilder sqlBuffer) {
        List<TriggerHistory> triggers = this.getActiveTriggerHistoriesForInactivation();
        for (TriggerHistory history : triggers) {
            this.log.info("TriggersRemoving", history.getSourceTableName());
            this.dbDialect.removeTrigger(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getNameForInsertTrigger(), history.getSourceTableName(), history);
            this.dbDialect.removeTrigger(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getNameForDeleteTrigger(), history.getSourceTableName(), history);
            this.dbDialect.removeTrigger(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getNameForUpdateTrigger(), history.getSourceTableName(), history);
            if (this.parameterService.is("auto.sync.triggers") && this.triggerCreationListeners != null) {
                for (ITriggerCreationListener l : this.triggerCreationListeners) {
                    l.triggerInactivated(null, history);
                }
            }
            boolean triggerExists = this.dbDialect.doesTriggerExist(history.getSourceCatalogName(), history.getSourceSchemaName(), history.getSourceTableName(), history.getNameForInsertTrigger());
            triggerExists |= this.dbDialect.doesTriggerExist(history.getSourceCatalogName(), history.getSourceSchemaName(), history.getSourceTableName(), history.getNameForUpdateTrigger());
            if (triggerExists |= this.dbDialect.doesTriggerExist(history.getSourceCatalogName(), history.getSourceSchemaName(), history.getSourceTableName(), history.getNameForDeleteTrigger())) {
                this.log.warn("TriggersRemovingFailed", history.getTriggerId(), history.getTriggerHistoryId());
                continue;
            }
            this.inactivateTriggerHistory(history);
        }
    }

    protected List<TriggerRouter> toList(Collection<List<TriggerRouter>> source) {
        ArrayList<TriggerRouter> list = new ArrayList<TriggerRouter>();
        for (List<TriggerRouter> triggerRouters : source) {
            for (TriggerRouter triggerRouter : triggerRouters) {
                list.add(triggerRouter);
            }
        }
        return list;
    }

    protected void updateOrCreateDatabaseTriggers(StringBuilder sqlBuffer, boolean gen_always) {
        List<Trigger> triggers = new TriggerSelector(this.toList(this.getTriggerRoutersForCurrentNode(true).values())).select();
        for (Trigger trigger : triggers) {
            String schemaPlusTriggerName = (trigger.getSourceSchemaName() != null ? trigger.getSourceSchemaName() + "." : "") + trigger.getSourceTableName();
            try {
                TriggerReBuildReason reason = TriggerReBuildReason.NEW_TRIGGERS;
                Table table = this.dbDialect.getTable(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), false);
                if (table != null) {
                    TriggerHistory latestHistoryBeforeRebuild = this.getNewestTriggerHistoryForTrigger(trigger.getTriggerId());
                    boolean forceRebuildOfTriggers = false;
                    if (latestHistoryBeforeRebuild == null) {
                        reason = TriggerReBuildReason.NEW_TRIGGERS;
                        forceRebuildOfTriggers = true;
                    } else if (TriggerHistory.calculateTableHashFor(table) != latestHistoryBeforeRebuild.getTableHash()) {
                        reason = TriggerReBuildReason.TABLE_SCHEMA_CHANGED;
                        forceRebuildOfTriggers = true;
                    } else if (trigger.hasChangedSinceLastTriggerBuild(latestHistoryBeforeRebuild.getCreateTime()) || trigger.toHashedValue() != latestHistoryBeforeRebuild.getTriggerRowHash()) {
                        reason = TriggerReBuildReason.TABLE_SYNC_CONFIGURATION_CHANGED;
                        forceRebuildOfTriggers = true;
                    } else if (gen_always) {
                        reason = TriggerReBuildReason.FORCED;
                        forceRebuildOfTriggers = true;
                    }
                    TriggerHistory newestHistory = this.rebuildTriggerIfNecessary(sqlBuffer, forceRebuildOfTriggers, trigger, DataEventType.INSERT, reason, latestHistoryBeforeRebuild, null, trigger.isSyncOnInsert(), table);
                    newestHistory = this.rebuildTriggerIfNecessary(sqlBuffer, forceRebuildOfTriggers, trigger, DataEventType.UPDATE, reason, latestHistoryBeforeRebuild, newestHistory, trigger.isSyncOnUpdate(), table);
                    newestHistory = this.rebuildTriggerIfNecessary(sqlBuffer, forceRebuildOfTriggers, trigger, DataEventType.DELETE, reason, latestHistoryBeforeRebuild, newestHistory, trigger.isSyncOnDelete(), table);
                    if (latestHistoryBeforeRebuild != null && newestHistory != null) {
                        this.inactivateTriggerHistory(latestHistoryBeforeRebuild);
                    }
                    if (newestHistory == null || !this.parameterService.is("auto.sync.triggers") || this.triggerCreationListeners == null) continue;
                    for (ITriggerCreationListener l : this.triggerCreationListeners) {
                        l.triggerCreated(trigger, newestHistory);
                    }
                    continue;
                }
                this.log.error("TriggerTableMissing", schemaPlusTriggerName);
                if (this.triggerCreationListeners == null) continue;
                for (ITriggerCreationListener l : this.triggerCreationListeners) {
                    l.tableDoesNotExist(trigger);
                }
            }
            catch (Exception ex) {
                this.log.error("TriggerSynchronizingFailed", ex, schemaPlusTriggerName);
                if (this.triggerCreationListeners == null) continue;
                for (ITriggerCreationListener l : this.triggerCreationListeners) {
                    l.triggerFailed(trigger, ex);
                }
            }
        }
    }

    protected TriggerHistory rebuildTriggerIfNecessary(StringBuilder sqlBuffer, boolean forceRebuild, Trigger trigger, DataEventType dmlType, TriggerReBuildReason reason, TriggerHistory oldhist, TriggerHistory hist, boolean triggerIsActive, Table table) {
        boolean isDeadTrigger;
        boolean triggerExists = false;
        TriggerHistory newTriggerHist = new TriggerHistory(table, trigger, reason);
        int maxTriggerNameLength = this.dbDialect.getMaxTriggerNameLength();
        newTriggerHist.setNameForInsertTrigger(this.getTriggerName(DataEventType.INSERT, maxTriggerNameLength, trigger).toUpperCase());
        newTriggerHist.setNameForUpdateTrigger(this.getTriggerName(DataEventType.UPDATE, maxTriggerNameLength, trigger).toUpperCase());
        newTriggerHist.setNameForDeleteTrigger(this.getTriggerName(DataEventType.DELETE, maxTriggerNameLength, trigger).toUpperCase());
        String oldTriggerName = null;
        String oldSourceSchema = null;
        String oldCatalogName = null;
        if (oldhist != null) {
            oldTriggerName = oldhist.getTriggerNameForDmlType(dmlType);
            oldSourceSchema = oldhist.getSourceSchemaName();
            oldCatalogName = oldhist.getSourceCatalogName();
            triggerExists = this.dbDialect.doesTriggerExist(oldCatalogName, oldSourceSchema, oldhist.getSourceTableName(), oldTriggerName);
        } else {
            oldTriggerName = newTriggerHist.getTriggerNameForDmlType(dmlType);
            oldSourceSchema = trigger.getSourceSchemaName();
            oldCatalogName = trigger.getSourceCatalogName();
            triggerExists = this.dbDialect.doesTriggerExist(oldCatalogName, oldSourceSchema, trigger.getSourceTableName(), oldTriggerName);
        }
        if (!triggerExists && forceRebuild) {
            reason = TriggerReBuildReason.TRIGGERS_MISSING;
        }
        if ((forceRebuild || !triggerIsActive) && triggerExists) {
            this.dbDialect.removeTrigger(sqlBuffer, oldCatalogName, oldSourceSchema, oldTriggerName, trigger.getSourceTableName(), oldhist);
            triggerExists = false;
        }
        boolean bl = isDeadTrigger = !trigger.isSyncOnInsert() && !trigger.isSyncOnUpdate() && !trigger.isSyncOnDelete();
        if (hist == null && (oldhist == null || !triggerExists && triggerIsActive || isDeadTrigger && forceRebuild)) {
            this.insert(newTriggerHist);
            hist = this.getNewestTriggerHistoryForTrigger(trigger.getTriggerId());
        }
        if (!triggerExists && triggerIsActive) {
            this.dbDialect.createTrigger(sqlBuffer, dmlType, trigger, hist, this.tablePrefix, table);
        }
        return hist;
    }

    protected String getTriggerName(DataEventType dml, int maxTriggerNameLength, Trigger trigger) {
        String triggerName = null;
        switch (dml) {
            case INSERT: {
                if (StringUtils.isBlank((String)trigger.getNameForInsertTrigger())) break;
                triggerName = trigger.getNameForInsertTrigger();
                break;
            }
            case UPDATE: {
                if (StringUtils.isBlank((String)trigger.getNameForUpdateTrigger())) break;
                triggerName = trigger.getNameForUpdateTrigger();
                break;
            }
            case DELETE: {
                if (StringUtils.isBlank((String)trigger.getNameForDeleteTrigger())) break;
                triggerName = trigger.getNameForDeleteTrigger();
            }
        }
        if (triggerName == null) {
            String triggerPrefix1 = this.tablePrefix + "_";
            String triggerSuffix1 = "on_" + dml.getCode().toLowerCase() + "_for_" + trigger.getTriggerId();
            String triggerSuffix2 = "_" + this.parameterService.getNodeGroupId().replaceAll("[^a-zA-Z0-9]|[a|e|i|o|u|A|E|I|O|U]", "");
            triggerName = triggerPrefix1 + triggerSuffix1 + triggerSuffix2;
            if (triggerName.length() > maxTriggerNameLength && maxTriggerNameLength > 0) {
                triggerName = triggerPrefix1 + triggerSuffix1;
            }
        }
        if ((triggerName = triggerName.toUpperCase()).length() > maxTriggerNameLength && maxTriggerNameLength > 0) {
            int duplicateCount = 0;
            do {
                if (duplicateCount == 0) {
                    triggerName = triggerName.substring(0, maxTriggerNameLength - 1);
                } else {
                    String duplicateSuffix = Integer.toString(duplicateCount);
                    triggerName = triggerName.substring(0, triggerName.length() - duplicateSuffix.length()) + duplicateSuffix;
                }
                ++duplicateCount;
            } while (this.isTriggerNameInUse(trigger.getTriggerId(), triggerName));
            this.log.debug("TriggerNameTruncated", dml.name().toLowerCase(), trigger.getTriggerId(), maxTriggerNameLength);
        }
        return triggerName;
    }

    public void setRootConfigChannelTableNames(Map<String, List<String>> configChannelTableNames) {
        this.rootConfigChannelTableNames = configChannelTableNames;
    }

    public void setRootConfigChannelInitialLoadSelect(Map<String, Map<String, String>> rootConfigChannelInitialLoadSelect) {
        this.rootConfigChannelInitialLoadSelect = rootConfigChannelInitialLoadSelect;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setTriggerCreationListeners(List<ITriggerCreationListener> autoTriggerCreationListeners) {
        if (this.triggerCreationListeners != null) {
            for (ITriggerCreationListener l : this.triggerCreationListeners) {
                this.addTriggerCreationListeners(l);
            }
        }
    }

    @Override
    public void addTriggerCreationListeners(ITriggerCreationListener l) {
        if (this.triggerCreationListeners == null) {
            this.triggerCreationListeners = new ArrayList<ITriggerCreationListener>();
        }
        this.triggerCreationListeners.add(l);
    }

    @Override
    public Map<Trigger, Exception> getFailedTriggers() {
        return this.failureListener.getFailures();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TriggerRoutersCache {
        Map<String, List<TriggerRouter>> triggerRoutersByTriggerId = new HashMap<String, List<TriggerRouter>>();
        Map<String, Router> routersByRouterId = new HashMap<String, Router>();

        public TriggerRoutersCache(Map<String, List<TriggerRouter>> triggerRoutersByTriggerId, Map<String, Router> routersByRouterId) {
            this.triggerRoutersByTriggerId = triggerRoutersByTriggerId;
            this.routersByRouterId = routersByRouterId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TriggerRouterMapper
    implements RowMapper<TriggerRouter> {
        TriggerRouterMapper() {
        }

        public TriggerRouter mapRow(ResultSet rs, int arg1) throws SQLException {
            TriggerRouter trig = new TriggerRouter();
            trig.getTrigger().setTriggerId(rs.getString("trigger_id"));
            trig.getTrigger().setChannelId(rs.getString("channel_id"));
            trig.getTrigger().setSourceTableName(rs.getString("source_table_name"));
            trig.getTrigger().setSyncOnInsert(rs.getBoolean("sync_on_insert"));
            trig.getTrigger().setSyncOnUpdate(rs.getBoolean("sync_on_update"));
            trig.getTrigger().setSyncOnDelete(rs.getBoolean("sync_on_delete"));
            trig.getTrigger().setSyncOnIncomingBatch(rs.getBoolean("sync_on_incoming_batch"));
            trig.getTrigger().setNameForDeleteTrigger(rs.getString("name_for_delete_trigger"));
            trig.getTrigger().setNameForInsertTrigger(rs.getString("name_for_insert_trigger"));
            trig.getTrigger().setNameForUpdateTrigger(rs.getString("name_for_update_trigger"));
            String schema = rs.getString("source_schema_name");
            trig.getTrigger().setSourceSchemaName(schema);
            String catalog = rs.getString("source_catalog_name");
            trig.getTrigger().setSourceCatalogName(catalog);
            String condition = rs.getString("sync_on_insert_condition");
            if (!StringUtils.isBlank((String)condition)) {
                trig.getTrigger().setSyncOnInsertCondition(condition);
            }
            if (!StringUtils.isBlank((String)(condition = rs.getString("sync_on_update_condition")))) {
                trig.getTrigger().setSyncOnUpdateCondition(condition);
            }
            if (!StringUtils.isBlank((String)(condition = rs.getString("sync_on_delete_condition")))) {
                trig.getTrigger().setSyncOnDeleteCondition(condition);
            }
            if (!StringUtils.isBlank((String)(condition = rs.getString("external_select")))) {
                trig.getTrigger().setExternalSelect(condition);
            }
            trig.getTrigger().setTxIdExpression(rs.getString("tx_id_expression"));
            trig.getTrigger().setCreateTime(rs.getTimestamp("t_create_time"));
            trig.getTrigger().setLastUpdateTime(rs.getTimestamp("t_last_update_time"));
            trig.getTrigger().setLastUpdateBy(rs.getString("t_last_update_by"));
            trig.getRouter().setSyncOnInsert(rs.getBoolean("r_sync_on_insert"));
            trig.getRouter().setSyncOnUpdate(rs.getBoolean("r_sync_on_update"));
            trig.getRouter().setSyncOnDelete(rs.getBoolean("r_sync_on_delete"));
            trig.getRouter().setTargetCatalogName(rs.getString("target_catalog_name"));
            trig.getRouter().setSourceNodeGroupId(rs.getString("source_node_group_id"));
            trig.getRouter().setTargetSchemaName(rs.getString("target_schema_name"));
            trig.getRouter().setTargetTableName(rs.getString("target_table_name"));
            trig.getRouter().setTargetNodeGroupId(rs.getString("target_node_group_id"));
            trig.getTrigger().setExcludedColumnNames(rs.getString("excluded_column_names"));
            condition = rs.getString("router_expression");
            if (!StringUtils.isBlank((String)condition)) {
                trig.getRouter().setRouterExpression(condition);
            }
            trig.getRouter().setRouterType(rs.getString("router_type"));
            trig.getRouter().setRouterId(rs.getString("router_id"));
            trig.getRouter().setCreateTime(rs.getTimestamp("r_create_time"));
            trig.getRouter().setLastUpdateTime(rs.getTimestamp("r_last_update_time"));
            trig.getRouter().setLastUpdateBy(rs.getString("r_last_update_by"));
            trig.setCreateTime(rs.getTimestamp("create_time"));
            trig.setLastUpdateTime(rs.getTimestamp("last_update_time"));
            trig.setLastUpdateBy(rs.getString("last_update_by"));
            trig.setInitialLoadOrder(rs.getInt("initial_load_order"));
            trig.setInitialLoadSelect(rs.getString("initial_load_select"));
            return trig;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TriggerHistoryMapper
    implements RowMapper<TriggerHistory> {
        Map<Long, TriggerHistory> retMap = null;

        TriggerHistoryMapper() {
        }

        TriggerHistoryMapper(Map<Long, TriggerHistory> map) {
            this.retMap = map;
        }

        public TriggerHistory mapRow(ResultSet rs, int i) throws SQLException {
            TriggerHistory hist = new TriggerHistory();
            hist.setTriggerHistoryId(rs.getInt(1));
            hist.setTriggerId(rs.getString(2));
            hist.setSourceTableName(rs.getString(3));
            hist.setTableHash(rs.getInt(4));
            hist.setCreateTime(rs.getTimestamp(5));
            hist.setPkColumnNames(rs.getString(6));
            hist.setColumnNames(rs.getString(7));
            hist.setLastTriggerBuildReason(TriggerReBuildReason.fromCode(rs.getString(8)));
            hist.setNameForDeleteTrigger(rs.getString(9));
            hist.setNameForInsertTrigger(rs.getString(10));
            hist.setNameForUpdateTrigger(rs.getString(11));
            hist.setSourceSchemaName(rs.getString(12));
            hist.setSourceCatalogName(rs.getString(13));
            hist.setTriggerRowHash(rs.getLong(14));
            if (this.retMap != null) {
                this.retMap.put(Long.valueOf(hist.getTriggerHistoryId()), hist);
            }
            return hist;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeGroupLinkMapper
    implements RowMapper<NodeGroupLink> {
        NodeGroupLinkMapper() {
        }

        public NodeGroupLink mapRow(ResultSet rs, int num) throws SQLException {
            NodeGroupLink node_groupTarget = new NodeGroupLink();
            node_groupTarget.setSourceNodeGroupId(rs.getString(1));
            node_groupTarget.setTargetNodeGroupId(rs.getString(2));
            node_groupTarget.setDataEventAction(NodeGroupLinkAction.fromCode(rs.getString(3)));
            return node_groupTarget;
        }
    }
}

