/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jumpmind.symmetric.service.IStatisticService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.statistic.Statistic;
import org.jumpmind.symmetric.statistic.StatisticAlertThresholds;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticService
extends AbstractService
implements IStatisticService {
    @Override
    public void save(Collection<Statistic> stats, Date captureEndTime) {
        if (stats != null) {
            for (Statistic statistic : stats) {
                this.jdbcTemplate.update(this.getSql("insertStatisticSql"), new Object[]{statistic.getNodeId(), AppUtils.getServerId(), statistic.getName(), statistic.getCaptureStartTimeMs(), captureEndTime, statistic.getTotal(), statistic.getCount()});
            }
        }
    }

    @Override
    public List<StatisticAlertThresholds> getAlertThresholds() {
        return this.getSimpleTemplate().query(this.getSql("getAlertThresholdsSql"), (RowMapper)new RowMapper<StatisticAlertThresholds>(){

            public StatisticAlertThresholds mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new StatisticAlertThresholds(rs.getString("statistic_name"), rs.getBigDecimal("threshold_total_max"), rs.getLong("threshold_count_max"), rs.getBigDecimal("threshold_total_min"), rs.getLong("threshold_count_min"), rs.getBigDecimal("threshold_avg_max"), rs.getBigDecimal("threshold_avg_min"));
            }
        }, new Object[0]);
    }

    @Override
    public void saveStatisticAlertThresholds(StatisticAlertThresholds threshold) {
        SimpleJdbcTemplate template = this.getSimpleTemplate();
        int updated = template.update(this.getSql("updateAlertThresholdsSql"), new Object[]{threshold.getThresholdTotalMax(), threshold.getThresholdCountMax(), threshold.getThresholdAvgMax(), threshold.getThresholdTotalMin(), threshold.getThresholdCountMin(), threshold.getThresholdAvgMin(), threshold.getStatisticName()});
        if (updated == 0) {
            template.update(this.getSql("insertAlertThresholdsSql"), new Object[]{threshold.getStatisticName(), threshold.getThresholdTotalMax(), threshold.getThresholdCountMax(), threshold.getThresholdAvgMax(), threshold.getThresholdTotalMin(), threshold.getThresholdCountMin(), threshold.getThresholdAvgMin()});
        }
    }

    @Override
    public boolean removeStatisticAlertThresholds(String statisticName) {
        return 1 == this.getSimpleTemplate().update(this.getSql("deleteAlertThresholdsSql"), new Object[]{statisticName});
    }
}

