/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.math.random.RandomDataImpl;
import org.jumpmind.symmetric.common.SecurityConstants;
import org.jumpmind.symmetric.service.ISecurityService;
import org.jumpmind.symmetric.service.impl.AbstractService;

public class SecurityService
extends AbstractService
implements ISecurityService {
    private SecretKey secretKey;

    public String encrypt(String plainText) {
        try {
            byte[] bytes = plainText.getBytes("UTF8");
            byte[] enc = this.getCipher(1).doFinal(bytes);
            return new String(Base64.encodeBase64((byte[])enc), "UTF8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String decrypt(String encText) {
        try {
            byte[] dec = Base64.decodeBase64((byte[])encText.getBytes());
            byte[] bytes = this.getCipher(2).doFinal(dec);
            return new String(bytes, "UTF8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Cipher getCipher(int mode) throws Exception {
        if (this.secretKey == null) {
            this.secretKey = this.getSecretKey();
        }
        Cipher cipher = Cipher.getInstance(this.secretKey.getAlgorithm());
        PBEParameterSpec paramSpec = new PBEParameterSpec(SecurityConstants.SALT, 3);
        cipher.init(mode, (Key)this.secretKey, paramSpec);
        return cipher;
    }

    private SecretKey getSecretKey() throws Exception {
        String password = System.getProperty("javax.net.ssl.keyStorePassword");
        password = password != null ? password : "changeit";
        KeyStore.PasswordProtection param = new KeyStore.PasswordProtection(password.toCharArray());
        KeyStore ks = this.getKeyStore(password);
        KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)ks.getEntry("sym.secret", param);
        if (entry == null) {
            this.log.debug("SecretKeyGenerating");
            String keyPassword = new RandomDataImpl().nextSecureHexString(16);
            PBEKeySpec keySpec = new PBEKeySpec(keyPassword.toCharArray(), SecurityConstants.SALT, 3);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndTripleDES").generateSecret(keySpec);
            entry = new KeyStore.SecretKeyEntry(key);
            ks.setEntry("sym.secret", entry, param);
            this.saveKeyStore(ks, password);
        } else {
            this.log.debug("SecretKeyRetrieving");
        }
        return entry.getSecretKey();
    }

    private KeyStore getKeyStore(String password) throws Exception {
        KeyStore ks = KeyStore.getInstance("JCEKS");
        FileInputStream is = new FileInputStream(System.getProperty("sym.keystore.file"));
        ks.load(is, password.toCharArray());
        is.close();
        return ks;
    }

    private void saveKeyStore(KeyStore ks, String password) throws Exception {
        FileOutputStream os = new FileOutputStream(System.getProperty("sym.keystore.file"));
        ks.store(os, password.toCharArray());
        os.close();
    }
}

