/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.security.INodePasswordFilter;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.RegistrationFailedException;
import org.jumpmind.symmetric.service.RegistrationRedirectException;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.util.RandomTimeSlot;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationService
extends AbstractService
implements IRegistrationService {
    private INodeService nodeService;
    private IDataExtractorService dataExtractorService;
    private IDataService dataService;
    private IDataLoaderService dataLoaderService;
    private ITransportManager transportManager;
    private RandomTimeSlot randomTimeSlot;
    private IDbDialect dbDialect;
    private INodePasswordFilter nodePasswordFilter;

    @Override
    public boolean registerNode(Node node, OutputStream out, boolean isRequestedRegistration) throws IOException {
        String redirectUrl;
        if (!this.nodeService.isRegistrationServer()) {
            NodeSecurity security;
            Node identity = this.nodeService.findIdentity();
            NodeSecurity nodeSecurity = security = identity == null ? null : this.nodeService.findNodeSecurity(identity.getNodeId());
            if (security == null || security.getInitialLoadTime() == null) {
                this.log.warn("RegistrationNotAllowedNoInitialLoad");
                return false;
            }
        }
        if ((redirectUrl = this.getRedirectionUrlFor(node.getExternalId())) != null) {
            this.log.info("RegistrationRedirecting", node.getExternalId(), redirectUrl);
            throw new RegistrationRedirectException(redirectUrl);
        }
        String nodeId = StringUtils.isBlank((String)node.getNodeId()) ? this.nodeService.getNodeIdGenerator().selectNodeId(this.nodeService, node) : node.getNodeId();
        Node targetNode = this.nodeService.findNode(nodeId);
        NodeSecurity security = this.nodeService.findNodeSecurity(nodeId);
        if ((targetNode == null || security == null || !security.isRegistrationEnabled()) && this.parameterService.is("auto.registration")) {
            this.openRegistration(node);
            nodeId = StringUtils.isBlank((String)node.getNodeId()) ? this.nodeService.getNodeIdGenerator().selectNodeId(this.nodeService, node) : node.getNodeId();
            security = this.nodeService.findNodeSecurity(nodeId);
        } else if (security == null || !security.isRegistrationEnabled()) {
            return false;
        }
        node.setNodeId(nodeId);
        this.jdbcTemplate.update(this.getSql("registerNodeSql"), new Object[]{node.getSyncUrl(), node.getSchemaVersion(), node.getDatabaseType(), node.getDatabaseVersion(), node.getSymmetricVersion(), node.getNodeId()}, new int[]{12, 12, 12, 12, 12, 12});
        if (node.getSymmetricVersion() != null && Version.isOlderThanVersion(node.getSymmetricVersion(), "1.6.0")) {
            this.markNodeAsRegistered(nodeId);
        }
        if (this.parameterService.is("auto.reload") && (security != null && security.getInitialLoadTime() == null || isRequestedRegistration)) {
            this.dataService.reloadNode(node.getNodeId());
        }
        this.dataExtractorService.extractConfigurationStandalone(node, out);
        return true;
    }

    @Override
    public String getRedirectionUrlFor(String externalId) {
        List list = this.jdbcTemplate.queryForList(this.getSql("getRegistrationRedirectUrlSql"), new Object[]{externalId}, new int[]{12}, String.class);
        if (list.size() > 0) {
            return this.transportManager.resolveURL((String)list.get(0), this.parameterService.getRegistrationUrl());
        }
        return null;
    }

    @Override
    public void saveRegistrationRedirect(String externalIdToRedirect, String nodeIdToRedirectTo) {
        int count = this.jdbcTemplate.update(this.getSql("updateRegistrationRedirectUrlSql"), new Object[]{nodeIdToRedirectTo, externalIdToRedirect}, new int[]{12, 12});
        if (count == 0) {
            this.jdbcTemplate.update(this.getSql("insertRegistrationRedirectUrlSql"), new Object[]{nodeIdToRedirectTo, externalIdToRedirect}, new int[]{12, 12});
        }
    }

    @Override
    @Transactional
    public void markNodeAsRegistered(String nodeId) {
        this.jdbcTemplate.update(this.getSql("registerNodeSecuritySql"), new Object[]{nodeId});
    }

    @Override
    public Map<String, String> getRegistrationRedirectMap() {
        return (Map)this.jdbcTemplate.query(this.getSql("getRegistrationRedirectSql"), new Object[0], (ResultSetExtractor)new ResultSetExtractor<Map<String, String>>(){

            public Map<String, String> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, String> results = new HashMap<String, String>();
                while (rs.next()) {
                    results.put(rs.getString(1), rs.getString(2));
                }
                return results;
            }
        });
    }

    private void sleepBeforeRegistrationRetry() {
        try {
            long sleepTimeInMs = 1000L * (long)this.randomTimeSlot.getRandomValueSeededByDomainId();
            this.log.warn("NodeRegistertingFailed", sleepTimeInMs);
            Thread.sleep(sleepTimeInMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isRegisteredWithServer() {
        return this.nodeService.findIdentity() != null;
    }

    @Override
    public void registerWithServer() {
        boolean registered = this.isRegisteredWithServer();
        int maxNumberOfAttempts = this.parameterService.getInt("registration.number.of.attempts");
        while (!(registered || maxNumberOfAttempts >= 0 && maxNumberOfAttempts <= 0)) {
            boolean errorOccurred = false;
            try {
                this.log.info("NodeRegisterting", this.parameterService.getRegistrationUrl());
                registered = this.dataLoaderService.loadData(this.transportManager.getRegisterTransport(new Node(this.parameterService, this.dbDialect), this.parameterService.getRegistrationUrl()));
            }
            catch (ConnectException e) {
                this.log.warn("NodeRegistertingFailedConnection");
            }
            catch (UnknownHostException e) {
                this.log.warn("NodeRegistertingFailedConnection");
            }
            catch (Exception e) {
                this.log.error(e);
            }
            if (!(registered || --maxNumberOfAttempts >= 0 && maxNumberOfAttempts <= 0)) {
                this.sleepBeforeRegistrationRetry();
                registered = this.isRegisteredWithServer();
                continue;
            }
            Node node = this.nodeService.findIdentity();
            if (node != null) {
                this.log.info("NodeRegistered", node.getNodeId());
                continue;
            }
            if (!errorOccurred) {
                this.log.error("NodeRegisteringFailedIdentityMissing");
                continue;
            }
            this.log.error("NodeRegisteringFailedUnavailable");
        }
        if (!registered) {
            throw new RegistrationFailedException(String.format("Failed after trying to register %s times.", this.parameterService.getString("registration.number.of.attempts")));
        }
    }

    @Override
    public synchronized void reOpenRegistration(String nodeId) {
        Node node = this.nodeService.findNode(nodeId);
        String password = this.nodeService.getNodeIdGenerator().generatePassword(this.nodeService, node);
        password = this.filterPasswordOnSaveIfNeeded(password);
        if (node != null) {
            int updateCount = this.jdbcTemplate.update(this.getSql("reopenRegistrationSql"), new Object[]{password, nodeId});
            if (updateCount == 0) {
                this.jdbcTemplate.update(this.getSql("openRegistrationNodeSecuritySql"), new Object[]{nodeId, password, this.nodeService.findNode(nodeId).getNodeId()});
            }
        } else {
            this.log.warn("NodeReregisteringFailed", nodeId);
        }
    }

    @Override
    public synchronized String openRegistration(String nodeGroup, String externalId) {
        Node node = new Node();
        node.setExternalId(externalId);
        node.setNodeGroupId(nodeGroup);
        return this.openRegistration(node);
    }

    protected synchronized String openRegistration(Node node) {
        Node me = this.nodeService.findIdentity();
        if (me != null || this.parameterService.getExternalId().equals(node.getExternalId()) && this.parameterService.getNodeGroupId().equals(node.getNodeGroupId())) {
            String nodeId = this.nodeService.getNodeIdGenerator().generateNodeId(this.nodeService, node);
            Node existingNode = this.nodeService.findNode(nodeId);
            if (existingNode == null) {
                String password = this.nodeService.getNodeIdGenerator().generatePassword(this.nodeService, node);
                password = this.filterPasswordOnSaveIfNeeded(password);
                this.nodeService.insertNode(nodeId, node.getNodeGroupId(), node.getExternalId(), me.getNodeId());
                this.jdbcTemplate.update(this.getSql("openRegistrationNodeSecuritySql"), new Object[]{nodeId, password, me.getNodeId()});
                this.nodeService.insertNodeGroup(node.getNodeGroupId(), null);
                this.log.info("NodeRegistrationOpened", node.getExternalId(), node.getNodeGroupId(), nodeId);
            } else {
                this.reOpenRegistration(nodeId);
            }
            return nodeId;
        }
        throw new IllegalStateException("This node has not been configured.  Could not find a row in the identity table.");
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDataExtractorService(IDataExtractorService dataExtractorService) {
        this.dataExtractorService = dataExtractorService;
    }

    public void setDataService(IDataService dataService) {
        this.dataService = dataService;
    }

    @Override
    public boolean isAutoRegistration() {
        return this.parameterService.is("auto.registration");
    }

    public void setDataLoaderService(IDataLoaderService dataLoaderService) {
        this.dataLoaderService = dataLoaderService;
    }

    public void setTransportManager(ITransportManager transportManager) {
        this.transportManager = transportManager;
    }

    @Override
    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    public void setRandomTimeSlot(RandomTimeSlot randomTimeSlot) {
        this.randomTimeSlot = randomTimeSlot;
    }

    @Override
    public void setNodePasswordFilter(INodePasswordFilter nodePasswordFilter) {
        this.nodePasswordFilter = nodePasswordFilter;
    }

    private String filterPasswordOnSaveIfNeeded(String password) {
        String s = password;
        if (this.nodePasswordFilter != null) {
            s = this.nodePasswordFilter.onNodeSecuritySave(password);
        }
        return s;
    }
}

