/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.BufferedReader;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.model.BatchInfo;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IPushService;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.service.impl.AbstractOfflineDetectorService;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.SyncDisabledException;
import org.jumpmind.symmetric.transport.TransportException;

public class PushService
extends AbstractOfflineDetectorService
implements IPushService {
    private IDataExtractorService extractor;
    private IAcknowledgeService ackService;
    private ITransportManager transportManager;
    private INodeService nodeService;
    private IDataService dataService;
    private IClusterService clusterService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean pushData() {
        boolean pushedData = false;
        boolean inError = false;
        if (this.nodeService.findIdentityNodeId() != null) {
            if (this.clusterService.lock("PUSH")) {
                try {
                    List<Node> nodes = this.nodeService.findNodesToPushTo();
                    if (nodes != null && nodes.size() > 0) {
                        for (Node node : nodes) {
                            this.log.debug("DataPushing", node);
                            PushStatus status = this.pushToNode(node);
                            if (status == PushStatus.PUSHED) {
                                pushedData = true;
                                this.log.info("DataPushed", node);
                            } else if (status == PushStatus.ERROR) {
                                inError = true;
                                this.log.warn("DataPushingFailed");
                            }
                            this.log.debug("DataPushingCompleted", node);
                        }
                    }
                    Object var8_7 = null;
                    this.clusterService.unlock("PUSH");
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.clusterService.unlock("PUSH");
                    throw throwable;
                }
            } else {
                this.log.info("DataPushingFailedLock");
            }
        }
        return pushedData && !inError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private PushStatus pushToNode(Node remote) {
        PushStatus status;
        block28: {
            IOutgoingTransport transport;
            block27: {
                status = PushStatus.ERROR;
                transport = null;
                NodeSecurity nodeSecurity = this.nodeService.findNodeSecurity(remote.getNodeId());
                if (nodeSecurity != null && nodeSecurity.isInitialLoadEnabled()) {
                    this.dataService.insertReloadEvent(remote);
                }
                NodeSecurity localNodeSecurity = this.nodeService.findNodeSecurity(this.nodeService.findIdentityNodeId());
                transport = this.transportManager.getPushTransport(remote, this.nodeService.findIdentity(), localNodeSecurity.getNodePassword(), this.parameterService.getRegistrationUrl());
                if (this.extractor.extract(remote, transport)) {
                    this.log.info("DataSent", remote);
                    BufferedReader reader = transport.readResponse();
                    String ackString = reader.readLine();
                    String ackExtendedString = reader.readLine();
                    this.log.debug("DataAckReading", ackString);
                    this.log.debug("DataAckExtendedReading", ackExtendedString);
                    if (StringUtils.isBlank((String)ackString)) {
                        this.log.error("DataAckReadingFailed");
                    }
                    List<BatchInfo> batches = this.transportManager.readAcknowledgement(ackString, ackExtendedString);
                    status = PushStatus.PUSHED;
                    for (BatchInfo batchInfo : batches) {
                        this.log.debug("DataAckSaving", batchInfo.getBatchId(), batchInfo.isOk() ? "OK" : "error");
                        if (!batchInfo.isOk()) {
                            status = PushStatus.ERROR;
                        }
                        this.ackService.ack(batchInfo);
                    }
                    break block27;
                }
                status = PushStatus.NOTHING_TO_PUSH;
            }
            Object var13_20 = null;
            try {
                transport.close();
            }
            catch (Exception e) {}
            break block28;
            {
                catch (ConnectException ex) {
                    this.log.warn("TransportFailedConnectionUnavailable", remote.getSyncUrl() == null ? this.parameterService.getRegistrationUrl() : remote.getSyncUrl());
                    this.fireOffline(ex, remote);
                    Object var13_21 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block28;
                }
                catch (ConnectionRejectedException ex) {
                    this.log.warn("TransportFailedConnectionBusy");
                    this.fireOffline(ex, remote);
                    Object var13_22 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block28;
                }
                catch (SocketException ex) {
                    this.log.warn("Message", ex.getMessage());
                    this.fireOffline(ex, remote);
                    Object var13_23 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block28;
                }
                catch (TransportException ex) {
                    this.log.warn("Message", ex.getMessage());
                    this.fireOffline(ex, remote);
                    Object var13_24 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block28;
                }
                catch (AuthenticationException ex) {
                    this.log.warn("AuthenticationFailed");
                    this.fireOffline(ex, remote);
                    Object var13_25 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block28;
                }
                catch (SyncDisabledException ex) {
                    this.log.warn("SyncDisabled");
                    this.fireOffline(ex, remote);
                    Object var13_26 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block28;
                }
                catch (RegistrationRequiredException ex) {
                    this.log.warn("RegistrationRequired");
                    this.fireOffline(ex, remote);
                    Object var13_27 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                    break block28;
                }
                catch (Exception ex) {
                    this.log.error(ex);
                    this.fireOffline(ex, remote);
                    Object var13_28 = null;
                    try {
                        transport.close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_29 = null;
                try {
                    transport.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return status;
    }

    public void setExtractor(IDataExtractorService extractor) {
        this.extractor = extractor;
    }

    public void setTransportManager(ITransportManager tm) {
        this.transportManager = tm;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAckService(IAcknowledgeService ackService) {
        this.ackService = ackService;
    }

    public void setDataService(IDataService dataService) {
        this.dataService = dataService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PushStatus {
        PUSHED,
        ERROR,
        NOTHING_TO_PUSH;

    }
}

