/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.config.IParameterFilter;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterService
extends AbstractService
implements IParameterService,
BeanFactoryAware {
    private Map<String, String> parameters;
    private BeanFactory beanFactory;
    private long cacheTimeoutInMs = 0L;
    private Date lastTimeParameterWereCached;
    private IParameterFilter parameterFilter;
    private Properties systemProperties = (Properties)System.getProperties().clone();
    private boolean initialized = false;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public BigDecimal getDecimal(String key, BigDecimal defaultVal) {
        String val = this.getString(key);
        if (val != null) {
            return new BigDecimal(val);
        }
        return defaultVal;
    }

    @Override
    public BigDecimal getDecimal(String key) {
        return this.getDecimal(key, BigDecimal.ZERO);
    }

    @Override
    public boolean is(String key) {
        return this.is(key, false);
    }

    @Override
    public boolean is(String key, boolean defaultVal) {
        String val = this.getString(key);
        if (val != null) {
            if ((val = val.trim()).equals("1")) {
                return true;
            }
            return Boolean.parseBoolean(val);
        }
        return false;
    }

    @Override
    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    @Override
    public int getInt(String key, int defaultVal) {
        String val = this.getString(key);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return defaultVal;
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Override
    public long getLong(String key, long defaultVal) {
        String val = this.getString(key);
        if (val != null) {
            return Long.parseLong(val);
        }
        return defaultVal;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String defaultVal) {
        String value = null;
        if (StringUtils.isBlank(value)) {
            value = this.getParameters().get(key);
        }
        if (this.parameterFilter != null) {
            value = this.parameterFilter.filterParameter(key, value);
        }
        return StringUtils.isBlank(value) ? defaultVal : value;
    }

    @Override
    public void saveParameter(String key, Object paramValue) {
        this.saveParameter("ALL", "ALL", key, paramValue);
    }

    @Override
    public void saveParameter(String externalId, String nodeGroupId, String key, Object paramValue) {
        paramValue = paramValue != null ? paramValue.toString() : null;
        int count = this.jdbcTemplate.update(this.getSql("updateParameterSql"), new Object[]{paramValue, externalId, nodeGroupId, key});
        if (count == 0) {
            this.jdbcTemplate.update(this.getSql("insertParameterSql"), new Object[]{externalId, nodeGroupId, key, paramValue});
        }
        this.rereadParameters();
    }

    @Override
    public void saveParameters(String externalId, String nodeGroupId, Map<String, Object> parameters) {
        Set<String> keys = parameters.keySet();
        for (String key : keys) {
            this.saveParameter(externalId, nodeGroupId, key, parameters.get(key));
        }
    }

    @Override
    public synchronized void rereadParameters() {
        this.parameters = null;
        this.getParameters();
    }

    private Properties rereadFileParameters() {
        return (Properties)this.beanFactory.getBean("symmetricProperties");
    }

    private Map<String, String> rereadDatabaseParameters(Properties p) {
        try {
            Map<String, String> map = this.rereadDatabaseParameters("ALL", "ALL");
            map.putAll(this.rereadDatabaseParameters("ALL", p.getProperty("group.id")));
            map.putAll(this.rereadDatabaseParameters(p.getProperty("external.id"), p.getProperty("group.id")));
            return map;
        }
        catch (Exception ex) {
            if (this.initialized) {
                this.log.warn("DatabaseParametersReadingFailed");
            }
            return new HashMap<String, String>();
        }
    }

    private Map<String, String> rereadDatabaseParameters(String externalId, String nodeGroupId) {
        final HashMap<String, String> map = new HashMap<String, String>();
        this.jdbcTemplate.query(this.getSql("selectParametersSql"), new Object[]{externalId, nodeGroupId}, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                map.put(rs.getString(1), rs.getString(2));
                return null;
            }
        });
        return map;
    }

    private Map<String, String> rereadApplicationParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties p = this.rereadFileParameters();
        p.putAll((Map<?, ?>)this.systemProperties);
        for (Object key : p.keySet()) {
            map.put((String)key, p.getProperty((String)key));
        }
        map.putAll(this.rereadDatabaseParameters(p));
        this.initialized = true;
        return map;
    }

    private Map<String, String> getParameters() {
        if (this.parameters == null || this.lastTimeParameterWereCached == null || this.cacheTimeoutInMs > 0L && this.lastTimeParameterWereCached.getTime() < System.currentTimeMillis() - this.cacheTimeoutInMs) {
            this.lastTimeParameterWereCached = new Date();
            this.parameters = this.rereadApplicationParameters();
            this.cacheTimeoutInMs = this.getInt("parameter.reload.timeout.ms");
        }
        return this.parameters;
    }

    @Override
    public Map<String, String> getAllParameters() {
        return this.getParameters();
    }

    @Override
    public Date getLastTimeParameterWereCached() {
        return this.lastTimeParameterWereCached;
    }

    @Override
    public void setParameterFilter(IParameterFilter parameterFilter) {
        this.parameterFilter = parameterFilter;
    }

    @Override
    public String getExternalId() {
        return this.getWithHostName("external.id");
    }

    @Override
    public String getSyncUrl() {
        String value = this.getWithHostName("sync.url");
        if (StringUtils.isBlank((String)value) && !StringUtils.isBlank((String)(value = this.getWithHostName("my.url")))) {
            this.log.warn("DeprecatedPropertyMsg", "my.url", "sync.url");
        }
        return value;
    }

    protected String getWithHostName(String paramKey) {
        String value = this.getString(paramKey);
        if (!StringUtils.isBlank((String)value)) {
            if (value.contains("hostName")) {
                value = AppUtils.replace("hostName", AppUtils.getHostName(), value);
            }
            if (value.contains("ipAddress")) {
                value = AppUtils.replace("ipAddress", AppUtils.getIpAddress(), value);
            }
        }
        return value;
    }

    @Override
    public String getNodeGroupId() {
        return this.getString("group.id");
    }

    @Override
    public String getRegistrationUrl() {
        return this.getString("registration.url");
    }
}

